/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.common.events.AnnotatedEventDriver;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageReader
extends Reader
implements MessageAppender {
    private final AnnotatedEventDriver driver;
    private final Utf8StringBuilder utf;
    private int size;
    private boolean finished;
    private boolean needsNotification;

    public MessageReader(AnnotatedEventDriver driver) {
        this.driver = driver;
        this.utf = new Utf8StringBuilder();
        this.size = 0;
        this.finished = false;
        this.needsNotification = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.driver.getPolicy().assertValidMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        Utf8StringBuilder utf8StringBuilder = this.utf;
        synchronized (utf8StringBuilder) {
            this.utf.append(payload);
        }
        if (this.needsNotification) {
            this.needsNotification = true;
            this.driver.onReader(this);
        }
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
    }

    @Override
    public void messageComplete() {
        this.finished = true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return 0;
    }
}

