/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.spdy.client.NPNClientConnection;
import org.eclipse.jetty.spdy.client.SPDYClient;

public class NPNClientConnectionFactory
implements ClientConnectionFactory {
    private final SPDYClient client;
    private final ClientConnectionFactory connectionFactory;

    public NPNClientConnectionFactory(SPDYClient client, ClientConnectionFactory connectionFactory) {
        this.client = client;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        return new NPNClientConnection(endPoint, this.client, this.connectionFactory, (SSLEngine)context.get("ssl.engine"), context);
    }
}

