/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNServerConnection
extends AbstractConnection
implements NextProtoNego.ServerProvider {
    private final Logger LOG = Log.getLogger(this.getClass());
    private final Connector connector;
    private final SSLEngine engine;
    private final List<String> protocols;
    private final String defaultProtocol;
    private String nextProtocol;

    public NPNServerConnection(EndPoint endPoint, SSLEngine engine, Connector connector, List<String> protocols, String defaultProtocol) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.protocols = protocols;
        this.defaultProtocol = defaultProtocol;
        this.engine = engine;
        NextProtoNego.put((SSLEngine)engine, (NextProtoNego.Provider)this);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void onFillable() {
        int filled = this.fill();
        if (filled == 0) {
            if (this.nextProtocol == null) {
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    this.LOG.debug("{} missing next protocol. SSLEngine: {}", this, this.engine);
                    this.close();
                } else {
                    this.fillInterested();
                }
            } else {
                ConnectionFactory connectionFactory = this.connector.getConnectionFactory(this.nextProtocol);
                if (connectionFactory == null) {
                    this.LOG.debug("{} application selected protocol '{}', but no correspondent {} has been configured", this, this.nextProtocol, ConnectionFactory.class.getName());
                    this.close();
                } else {
                    EndPoint endPoint = this.getEndPoint();
                    Connection oldConnection = endPoint.getConnection();
                    Connection newConnection = connectionFactory.newConnection(this.connector, endPoint);
                    this.LOG.debug("{} switching from {} to {}", this, oldConnection, newConnection);
                    oldConnection.onClose();
                    endPoint.setConnection(newConnection);
                    this.getEndPoint().getConnection().onOpen();
                }
            }
        } else if (filled < 0) {
            this.LOG.debug("{} closing on client close", this);
            this.close();
        } else {
            throw new IllegalStateException();
        }
    }

    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            this.LOG.debug(x);
            this.close();
            return -1;
        }
    }

    public void unsupported() {
        this.protocolSelected(this.defaultProtocol);
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public void protocolSelected(String protocol) {
        this.LOG.debug("{} protocol selected {}", this, protocol);
        this.nextProtocol = protocol != null ? protocol : this.defaultProtocol;
        NextProtoNego.remove((SSLEngine)this.engine);
    }

    @Override
    public void close() {
        NextProtoNego.remove((SSLEngine)this.engine);
        EndPoint endPoint = this.getEndPoint();
        endPoint.shutdownOutput();
        endPoint.close();
    }
}

