/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.StandardCompressionFactory;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.client.FlowControlStrategyFactory;
import org.eclipse.jetty.spdy.client.SPDYConnection;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="SPDY Server Connection Factory")
public class SPDYServerConnectionFactory
extends AbstractConnectionFactory {
    private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
    private final short version;
    private final ServerSessionFrameListener listener;
    private int initialWindowSize;
    private boolean dispatchIO;

    public static void checkNPNAvailable() {
        try {
            Class<?> npn = ClassLoader.getSystemClassLoader().loadClass("org.eclipse.jetty.npn.NextProtoNego");
            if (npn.getClassLoader() != null) {
                throw new IllegalStateException("NextProtoNego must be on JVM boot path");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("No NextProtoNego on boot path", e);
        }
    }

    public SPDYServerConnectionFactory(int version) {
        this(version, null);
    }

    public SPDYServerConnectionFactory(int version, ServerSessionFrameListener listener) {
        super("spdy/" + version);
        this.version = (short)version;
        this.listener = listener;
        this.setInitialWindowSize(65536);
        this.setDispatchIO(true);
    }

    @ManagedAttribute(value="SPDY version")
    public short getVersion() {
        return this.version;
    }

    public ServerSessionFrameListener getServerSessionFrameListener() {
        return this.listener;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        StandardCompressionFactory compressionFactory = new StandardCompressionFactory();
        Parser parser = new Parser(compressionFactory.newDecompressor());
        Generator generator = new Generator(connector.getByteBufferPool(), compressionFactory.newCompressor());
        ServerSessionFrameListener listener = this.provideServerSessionFrameListener(connector, endPoint);
        ServerSPDYConnection connection = new ServerSPDYConnection(connector, endPoint, parser, listener, this.isDispatchIO(), this.getInputBufferSize());
        FlowControlStrategy flowControlStrategy = this.newFlowControlStrategy(this.version);
        StandardSession session = new StandardSession(this.getVersion(), connector.getByteBufferPool(), connector.getScheduler(), connection, endPoint, connection, 2, listener, generator, flowControlStrategy);
        session.setWindowSize(this.getInitialWindowSize());
        parser.addListener(session);
        connection.setSession(session);
        this.sessionOpened(session);
        return this.configure(connection, connector, endPoint);
    }

    protected FlowControlStrategy newFlowControlStrategy(short version) {
        return FlowControlStrategyFactory.newFlowControlStrategy(version);
    }

    protected ServerSessionFrameListener provideServerSessionFrameListener(Connector connector, EndPoint endPoint) {
        return this.listener;
    }

    @ManagedAttribute(value="Initial Window Size")
    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    @ManagedAttribute(value="Dispatch I/O to a pooled thread")
    public boolean isDispatchIO() {
        return this.dispatchIO;
    }

    public void setDispatchIO(boolean dispatchIO) {
        this.dispatchIO = dispatchIO;
    }

    protected boolean sessionOpened(Session session) {
        return this.sessions.offer(session);
    }

    protected boolean sessionClosed(Session session) {
        return this.sessions.remove(session);
    }

    void closeSessions() {
        for (Session session : this.sessions) {
            session.goAway(new GoAwayInfo(), new Callback.Adapter());
        }
        this.sessions.clear();
    }

    @Override
    protected void doStop() throws Exception {
        this.closeSessions();
        super.doStop();
    }

    public Collection<Session> getSessions() {
        return Collections.unmodifiableCollection(this.sessions);
    }

    @Override
    protected void dumpThis(Appendable out) throws IOException {
        super.dumpThis(out);
        SPDYServerConnectionFactory.dump(out, "", this.sessions);
    }

    private class ServerSPDYConnection
    extends SPDYConnection
    implements Runnable {
        private final ServerSessionFrameListener listener;
        private final AtomicBoolean connected;

        private ServerSPDYConnection(Connector connector, EndPoint endPoint, Parser parser, ServerSessionFrameListener listener, boolean dispatchIO, int bufferSize) {
            super(endPoint, connector.getByteBufferPool(), parser, connector.getExecutor(), dispatchIO, bufferSize);
            this.connected = new AtomicBoolean();
            this.listener = listener;
        }

        @Override
        public void onOpen() {
            super.onOpen();
            if (this.connected.compareAndSet(false, true)) {
                this.getExecutor().execute(this);
            }
        }

        @Override
        public void onClose() {
            super.onClose();
            SPDYServerConnectionFactory.this.sessionClosed(this.getSession());
        }

        @Override
        public void run() {
            if (this.listener != null) {
                this.listener.onConnect(this.getSession());
            }
        }
    }
}

