/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.Callback;

public class DeferredContentProvider
implements AsyncContentProvider,
Closeable {
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final Object lock = this;
    private final Queue<ByteBuffer> chunks = new ArrayQueue<ByteBuffer>(4, 64, this.lock);
    private final AtomicReference<AsyncContentProvider.Listener> listener = new AtomicReference();
    private final Iterator<ByteBuffer> iterator = new DeferredContentProviderIterator();
    private final AtomicBoolean closed = new AtomicBoolean();
    private int size;
    private Throwable failure;

    public DeferredContentProvider(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.offer(buffer);
        }
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        if (!this.listener.compareAndSet(null, listener)) {
            throw new IllegalStateException(String.format("The same %s instance cannot be used in multiple requests", AsyncContentProvider.class.getName()));
        }
    }

    @Override
    public long getLength() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(ByteBuffer buffer) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            result = this.chunks.offer(buffer);
            if (result && buffer != CLOSE) {
                ++this.size;
            }
        }
        if (result) {
            this.notifyListener();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                while (true) {
                    if (this.failure != null) {
                        throw new IOException(this.failure);
                    }
                    if (this.size != 0) {
                        this.lock.wait();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.offer(CLOSE);
        }
    }

    private void notifyListener() {
        AsyncContentProvider.Listener listener = this.listener.get();
        if (listener != null) {
            listener.onContent();
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    private class DeferredContentProviderIterator
    implements Iterator<ByteBuffer>,
    Callback {
        private ByteBuffer current;

        private DeferredContentProviderIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                return DeferredContentProvider.this.chunks.peek() != CLOSE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer next() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                ByteBuffer element = this.current = (ByteBuffer)DeferredContentProvider.this.chunks.poll();
                if (element == CLOSE) {
                    throw new NoSuchElementException();
                }
                return element;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                if (this.current != null) {
                    --DeferredContentProvider.this.size;
                    DeferredContentProvider.this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable x) {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                DeferredContentProvider.this.failure = x;
                DeferredContentProvider.this.lock.notify();
            }
        }
    }
}

