/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.npn.server;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.npn.NextProtoNego;
import org.eclipse.jetty.npn.server.NPNServerConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NPNServerConnectionFactory
extends NegotiatingServerConnectionFactory {
    private static final Logger LOG = Log.getLogger(NPNServerConnectionFactory.class);

    public NPNServerConnectionFactory(String protocols) {
        this(protocols.trim().split(",", 0));
    }

    public NPNServerConnectionFactory(String ... protocols) {
        super("npn", protocols);
        try {
            ClassLoader npnClassLoader = NextProtoNego.class.getClassLoader();
            if (npnClassLoader != null) {
                LOG.warn("NPN must be in the boot classloader, not in: " + npnClassLoader, new Object[0]);
                throw new IllegalStateException("NPN must be in the boot classloader");
            }
        }
        catch (Throwable x) {
            LOG.warn("NPN not available: " + x, new Object[0]);
            throw new IllegalStateException("NPN not available", x);
        }
    }

    @Override
    protected AbstractConnection newServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        return new NPNServerConnection(endPoint, engine, connector, protocols, defaultProtocol);
    }
}

