/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel
implements Runnable,
HttpOutput.Interceptor {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private static final ThreadLocal<HttpChannel> __currentChannel = new ThreadLocal();
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicInteger _requests = new AtomicInteger();
    private final Connector _connector;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private MetaData.Response _committedMetaData;
    private RequestLog _requestLog;
    private long _written;

    public static HttpChannel getCurrentHttpChannel() {
        return __currentChannel.get();
    }

    protected static HttpChannel setCurrentHttpChannel(HttpChannel channel) {
        HttpChannel last = __currentChannel.get();
        if (channel == null) {
            __currentChannel.remove();
        } else {
            __currentChannel.set(channel);
        }
        return last;
    }

    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInput input) {
        this._connector = connector;
        this._configuration = configuration;
        this._endPoint = endPoint;
        this._transport = transport;
        this._state = new HttpChannelState(this);
        input.init(this._state);
        this._request = new Request(this, input);
        this._response = new Response(this, new HttpOutput(this));
        this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public int getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    public void setRequestLog(RequestLog requestLog) {
        this._requestLog = requestLog;
    }

    public MetaData.Response getCommittedInfo() {
        return this._committedMetaData;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._endPoint.setIdleTimeout(timeoutMs);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    public void continue100(int available) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void recycle() {
        this._committed.set(false);
        this._request.recycle();
        this._response.recycle();
        this._committedMetaData = null;
        this._requestLog = this._connector == null ? null : this._connector.getServer().getRequestLog();
        this._written = 0L;
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handle() {
        block41: {
            last = HttpChannel.setCurrentHttpChannel(this);
            threadName = null;
            if (HttpChannel.LOG.isDebugEnabled()) {
                threadName = Thread.currentThread().getName();
                Thread.currentThread().setName(threadName + " - " + this._request.getHttpURI());
                HttpChannel.LOG.debug("{} handle enter", new Object[]{this});
            }
            action = this._state.handling();
            try lbl-1000:
            // 13 sources

            {
                block26: while (action.ordinal() < HttpChannelState.Action.WAIT.ordinal() && this.getServer().isRunning()) {
                    error = false;
                    try {
                        if (HttpChannel.LOG.isDebugEnabled()) {
                            HttpChannel.LOG.debug("{} action {}", new Object[]{this, action});
                        }
                        switch (1.$SwitchMap$org$eclipse$jetty$server$HttpChannelState$Action[action.ordinal()]) {
                            case 1: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.REQUEST);
                                customizers = this._configuration.getCustomizers();
                                if (!customizers.isEmpty()) {
                                    for (HttpConfiguration.Customizer customizer : customizers) {
                                        customizer.customize(this.getConnector(), this._configuration, this._request);
                                    }
                                }
                                this.getServer().handle(this);
                                ** break;
                            }
                            case 2: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.ASYNC);
                                this.getServer().handleAsync(this);
                                ** break;
                            }
                            case 3: {
                                this._request.setHandled(false);
                                this._response.getHttpOutput().reopen();
                                this._request.setDispatcherType(DispatcherType.ERROR);
                                ex = this._state.getAsyncContextEvent().getThrowable();
                                reason = "Async Timeout";
                                if (ex != null) {
                                    reason = "Async Exception";
                                    this._request.setAttribute("javax.servlet.error.exception", ex);
                                }
                                this._request.setAttribute("javax.servlet.error.status_code", new Integer(500));
                                this._request.setAttribute("javax.servlet.error.message", reason);
                                this._request.setAttribute("javax.servlet.error.request_uri", this._request.getRequestURI());
                                this._response.setStatusWithReason(500, reason);
                                eh = ErrorHandler.getErrorHandler(this.getServer(), this._state.getContextHandler());
                                if (eh instanceof ErrorHandler.ErrorPageMapper && (error_page = ((ErrorHandler.ErrorPageMapper)eh).getErrorPage((HttpServletRequest)this._state.getAsyncContextEvent().getSuppliedRequest())) != null) {
                                    this._state.getAsyncContextEvent().setDispatchPath(error_page);
                                }
                                this.getServer().handleAsync(this);
                                ** break;
                            }
                            case 4: {
                                handler = this._state.getContextHandler();
                                if (handler != null) {
                                    handler.handle(this._request.getHttpInput());
                                    ** break;
                                }
                                this._request.getHttpInput().run();
                                ** break;
                            }
                            case 5: {
                                handler = this._state.getContextHandler();
                                if (handler != null) {
                                    handler.handle(this._response.getHttpOutput());
                                    ** break;
                                }
                                this._response.getHttpOutput().run();
                                ** break;
                            }
                            ** default:
lbl65:
                            // 1 sources

                            break block26;
                        }
                    }
                    catch (Error e) {
                        if ("ContinuationThrowable".equals(e.getClass().getSimpleName())) {
                            HttpChannel.LOG.ignore(e);
                            continue;
                        }
                        error = true;
                        HttpChannel.LOG.warn(String.valueOf(this._request.getHttpURI()), e);
                        this._state.error(e);
                        this._request.setHandled(true);
                        this.handleException(e);
                    }
                    catch (EofException | QuietServletException e) {
                        error = true;
                        HttpChannel.LOG.debug((Throwable)e);
                        this._state.error((Throwable)e);
                        this._request.setHandled(true);
                        this.handleException((Throwable)e);
                    }
                    catch (Exception e) {
                        error = true;
                        HttpChannel.LOG.warn(String.valueOf(this._request.getHttpURI()), e);
                        this._state.error(e);
                        this._request.setHandled(true);
                        this.handleException(e);
                    }
                    finally {
                        if (error && this._state.isAsyncStarted()) {
                            this._state.errorComplete();
                        }
                        action = this._state.unhandle();
                    }
                }
                if (action != HttpChannelState.Action.COMPLETE) break block41;
                try {
                    this._state.completed();
                    if (!this._response.isCommitted() && !this._request.isHandled()) {
                        this._response.sendError(404);
                    } else {
                        this._response.closeOutput();
                    }
                }
                catch (ClosedChannelException | EofException e) {
                    HttpChannel.LOG.debug(e);
                }
                catch (Exception e) {
                    HttpChannel.LOG.warn("complete failed", e);
                }
                finally {
                    this._request.setHandled(true);
                    this.onCompleted();
                }
            }
            finally {
                HttpChannel.setCurrentHttpChannel(last);
                if (threadName != null && HttpChannel.LOG.isDebugEnabled()) {
                    Thread.currentThread().setName(threadName);
                }
            }
        }
        if (HttpChannel.LOG.isDebugEnabled()) {
            HttpChannel.LOG.debug("{} handle exit, result {}", new Object[]{this, action});
        }
        return action != HttpChannelState.Action.WAIT;
    }

    protected void handleException(Throwable x) {
        try {
            this._request.setAttribute("javax.servlet.error.exception", x);
            this._request.setAttribute("javax.servlet.error.exception_type", x.getClass());
            if (this._state.isSuspended()) {
                HttpFields fields = new HttpFields();
                fields.add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                MetaData.Response info = new MetaData.Response(this._request.getHttpVersion(), 500, null, fields, 0L);
                boolean committed = this.sendResponse(info, null, true);
                if (!committed) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
                this._request.getAsyncContext().complete();
            } else if (this.isCommitted()) {
                this._transport.abort(x);
                if (!(x instanceof EofException)) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
            } else {
                this._response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                this._response.sendError(500, x.getMessage());
            }
        }
        catch (IOException e) {
            LOG.debug("Could not commit response error 500", e);
        }
    }

    public boolean isExpecting100Continue() {
        return false;
    }

    public boolean isExpecting102Processing() {
        return false;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,c=%b,a=%s,uri=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._committed.get(), this._state.getState(), this._state.getState() == HttpChannelState.State.IDLE ? "-" : this._request.getRequestURI()});
    }

    public void onRequest(MetaData.Request request) {
        this._requests.incrementAndGet();
        this._request.setTimeStamp(System.currentTimeMillis());
        if (this._configuration.getSendDateHeader()) {
            this._response.getHttpFields().put(this._connector.getServer().getDateField());
        }
        this._request.setMetaData(request);
    }

    public void onContent(HttpInput.Content content) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} content {}", this, content);
        }
        HttpInput input = this._request.getHttpInput();
        input.content(content);
    }

    public void onRequestComplete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onRequestComplete", this);
        }
        this._request.getHttpInput().messageComplete();
    }

    public void onCompleted() {
        if (this._requestLog != null) {
            this._requestLog.log(this._request, this._committedMetaData == null ? -1 : this._committedMetaData.getStatus(), this._written);
        }
        this._transport.completed();
    }

    public void onEarlyEOF() {
        this._request.getHttpInput().earlyEOF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBadMessage(int status, String reason) {
        if (status < 400 || status > 599) {
            status = 400;
        }
        try {
            if (this._state.handling() == HttpChannelState.Action.REQUEST_DISPATCH) {
                ByteBuffer content = null;
                HttpFields fields = new HttpFields();
                ErrorHandler handler = this.getServer().getBean(ErrorHandler.class);
                if (handler != null) {
                    content = handler.badMessageError(status, reason, fields);
                }
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, status, reason, fields, 0L), content, true);
            }
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        finally {
            if (this._state.unhandle() != HttpChannelState.Action.COMPLETE) {
                throw new IllegalStateException();
            }
            this._state.completed();
            this.onCompleted();
        }
    }

    protected boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete, Callback callback) {
        boolean committing = this._committed.compareAndSet(false, true);
        if (committing) {
            if (info == null) {
                info = this._response.newResponseMetaData();
            }
            this.commit(info);
            int status = info.getStatus();
            CommitCallback committed = status < 200 && status >= 100 ? new Commit100Callback(callback) : new CommitCallback(callback);
            this._transport.send(info, this._request.isHead(), content, complete, committed);
        } else if (info == null) {
            this._transport.send(null, this._request.isHead(), content, complete, callback);
        } else {
            callback.failed(new IllegalStateException("committed"));
        }
        return committing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendResponse(MetaData.Response info, ByteBuffer content, boolean complete) throws IOException {
        try (SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();){
            boolean committing = this.sendResponse(info, content, complete, blocker);
            blocker.block();
            boolean bl = committing;
            return bl;
        }
        catch (Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(failure);
            }
            this.abort(failure);
            throw failure;
        }
    }

    protected void commit(MetaData.Response info) {
        this._committedMetaData = info;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Commit {} to {}", info, this);
        }
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    @Override
    public void write(ByteBuffer content, boolean complete, Callback callback) {
        this._written += (long)BufferUtil.length(content);
        this.sendResponse(null, content, complete, callback);
    }

    protected void execute(Runnable task) {
        this._connector.getExecutor().execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    public void abort(Throwable failure) {
        this._transport.abort(failure);
    }

    private class Commit100Callback
    extends CommitCallback {
        private Commit100Callback(Callback callback) {
            super(callback);
        }

        @Override
        public void succeeded() {
            if (HttpChannel.this._committed.compareAndSet(true, false)) {
                super.succeeded();
            } else {
                super.failed(new IllegalStateException());
            }
        }
    }

    private class CommitCallback
    implements Callback {
        private final Callback _callback;

        private CommitCallback(Callback callback) {
            this._callback = callback;
        }

        @Override
        public void succeeded() {
            this._callback.succeeded();
        }

        @Override
        public void failed(final Throwable x) {
            if (x instanceof EofException || x instanceof ClosedChannelException) {
                LOG.debug(x);
                this._callback.failed(x);
                HttpChannel.this._response.getHttpOutput().closed();
            } else {
                HttpChannel.this._committed.set(false);
                LOG.warn("Commit failed", x);
                HttpChannel.this.sendResponse(HttpGenerator.RESPONSE_500_INFO, null, true, new Callback(){

                    @Override
                    public void succeeded() {
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }

                    @Override
                    public void failed(Throwable th) {
                        LOG.ignore(th);
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }
                });
            }
        }
    }
}

