/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", this, stream.getId());
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    @Override
    public void send(MetaData.Response info, boolean isHeadRequest, final ByteBuffer content, final boolean lastContent, final Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent(content) && !isHeadRequest;
        if (info != null) {
            int status = info.getStatus();
            boolean informational = HttpStatus.isInformational(status) && status != 101;
            boolean committed = false;
            if (!informational) {
                committed = this.commit.compareAndSet(false, true);
            }
            if (committed || informational) {
                if (hasContent) {
                    Callback.Nested commitCallback = new Callback.Nested(callback){

                        @Override
                        public void succeeded() {
                            if (HttpTransportOverHTTP2.this.transportCallback.start(callback, false)) {
                                HttpTransportOverHTTP2.this.send(content, lastContent, HttpTransportOverHTTP2.this.transportCallback);
                            }
                        }
                    };
                    if (this.transportCallback.start(commitCallback, true)) {
                        this.commit(info, false, this.transportCallback);
                    }
                } else if (this.transportCallback.start(callback, false)) {
                    this.commit(info, lastContent, this.transportCallback);
                }
            } else {
                callback.failed(new IllegalStateException("committed"));
            }
        } else if (hasContent || lastContent) {
            if (this.transportCallback.start(callback, false)) {
                this.send(content, lastContent, this.transportCallback);
            }
        } else {
            callback.succeeded();
        }
    }

    @Override
    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    @Override
    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", request);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", request);
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, request), new Promise<Stream>(){

            @Override
            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            @Override
            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, new Stream.Listener.Adapter());
    }

    private void commit(MetaData.Response info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), info, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void send(ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : "");
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, lastContent);
        this.stream.data(frame, callback);
    }

    public void onStreamFailure(Throwable failure) {
        this.transportCallback.failed(failure);
    }

    public boolean onStreamTimeout(Throwable failure) {
        return this.transportCallback.onIdleTimeout(failure);
    }

    @Override
    public void onCompleted() {
        HttpChannelOverHTTP2 channel;
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}: unconsumed request content, resetting stream", this.stream.getId());
            }
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        if ((channel = (HttpChannelOverHTTP2)this.stream.getAttribute(IStream.CHANNEL_ATTRIBUTE)) != null) {
            channel.consumeInput();
        }
    }

    @Override
    public void abort(Throwable failure) {
        IStream stream = this.stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{} aborted", stream == null ? -1 : stream.getId(), stream == null ? Integer.valueOf(-1) : Integer.toHexString(stream.getSession().hashCode()));
        }
        if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.INTERNAL_ERROR.code), Callback.NOOP);
        }
    }

    private static enum State {
        IDLE,
        WRITING,
        FAILED,
        TIMEOUT;

    }

    private class TransportCallback
    implements Callback {
        private State state = State.IDLE;
        private Callback callback;
        private boolean commit;

        private TransportCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start(Callback callback, boolean commit) {
            State state;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                state = this.state;
                if (state == State.IDLE) {
                    this.state = State.WRITING;
                    this.callback = callback;
                    this.commit = commit;
                    return true;
                }
            }
            callback.failed(new IllegalStateException("Invalid transport state: " + (Object)((Object)state)));
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void succeeded() {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state == State.WRITING) {
                    callback = this.callback;
                    this.callback = null;
                    this.state = State.IDLE;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{} {}", HttpTransportOverHTTP2.this.stream.getId(), commit ? "committed" : "flushed content");
            }
            if (callback != null) {
                callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable x) {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state == State.WRITING) {
                    callback = this.callback;
                    this.callback = null;
                    this.state = State.FAILED;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " failed to " + (commit ? "commit" : "flush"), x);
            }
            if (callback != null) {
                callback.failed(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Invocable.InvocationType getInvocationType() {
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                callback = this.callback;
            }
            return callback.getInvocationType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onIdleTimeout(Throwable failure) {
            boolean result;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                boolean bl = result = this.state == State.WRITING;
                if (result) {
                    callback = this.callback;
                    this.callback = null;
                    this.state = State.TIMEOUT;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #" + HttpTransportOverHTTP2.this.stream.getId() + " idle timeout", failure);
            }
            if (result) {
                callback.failed(failure);
            }
            return result;
        }
    }
}

