/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionCollection {
    public static final String INJECTION_COLLECTION = "org.eclipse.jetty.injectionCollection";
    private HashMap<String, List<Injection>> _injectionMap = new HashMap();

    public void add(Injection injection) {
        List<Injection> injections;
        if (injection == null || injection.getTargetClassName() == null) {
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Adding injection for class=" + injection.getTargetClassName() + " on a " + (injection.isField() ? injection.getFieldName() : injection.getMethodName()));
        }
        if ((injections = this._injectionMap.get(injection.getTargetClassName())) == null) {
            injections = new ArrayList<Injection>();
            this._injectionMap.put(injection.getTargetClassName(), injections);
        }
        injections.add(injection);
    }

    public List<Injection> getInjections(String className) {
        if (className == null) {
            return null;
        }
        return this._injectionMap.get(className);
    }

    public Injection getInjection(String jndiName, String className, String fieldName) {
        if (fieldName == null || className == null) {
            return null;
        }
        List<Injection> injections = this.getInjections(className);
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!fieldName.equals(i.getFieldName())) continue;
            injection = i;
        }
        return injection;
    }

    public Injection getInjection(String jndiName, String className, String methodName, String paramCanonicalName) {
        if (className == null || methodName == null || paramCanonicalName == null) {
            return null;
        }
        List<Injection> injections = this.getInjections(className);
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!methodName.equals(i.getMethodName()) || !paramCanonicalName.equals(i.getParamCanonicalName())) continue;
            injection = i;
        }
        return injection;
    }

    public void inject(Object injectable) throws Exception {
        if (injectable == null) {
            return;
        }
        for (Class<?> clazz = injectable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List<Injection> injections = this._injectionMap.get(clazz.getCanonicalName());
            if (injections == null) continue;
            for (Injection i : injections) {
                i.inject(injectable);
            }
        }
    }
}

