/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jsp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.servlet.JspServlet;

public class JettyJspServlet
extends JspServlet {
    private static final long serialVersionUID = -5387857473125086791L;

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = null;
        if (!(req instanceof HttpServletRequest)) {
            throw new ServletException("Request not HttpServletRequest");
        }
        request = req;
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        String pathInContext = this.addPaths(servletPath, pathInfo);
        String jspFile = this.getInitParameter("jspFile");
        if (jspFile == null) {
            Path asPath;
            if (pathInContext != null && pathInContext.endsWith("/")) {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            String realPath = this.getServletContext().getRealPath(pathInContext);
            if (realPath != null && Files.exists(asPath = Paths.get(realPath, new String[0]), new LinkOption[0]) && Files.isDirectory(asPath, new LinkOption[0])) {
                this.getServletContext().getNamedDispatcher("default").forward((ServletRequest)req, (ServletResponse)resp);
                return;
            }
        }
        super.service(req, resp);
    }

    private String addPaths(String servletPath, String pathInfo) {
        if (servletPath.length() == 0) {
            return pathInfo;
        }
        if (pathInfo == null) {
            return servletPath;
        }
        return servletPath + pathInfo;
    }
}

