/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jetty.ee10.maven.plugin.JettyEmbedder;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyForkedChild
extends ContainerLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(JettyForkedChild.class);
    protected JettyEmbedder jetty = new JettyEmbedder();
    protected File tokenFile;
    protected Scanner scanner;
    protected File webAppPropsFile;
    protected int scanInterval;

    public JettyForkedChild(String[] args) throws Exception {
        this.configure(args);
    }

    public void configure(String[] args) throws Exception {
        HashMap<String, String> jettyProperties = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if ("--stop-port".equals(args[i])) {
                this.jetty.setStopPort(Integer.parseInt(args[++i]));
                continue;
            }
            if ("--stop-key".equals(args[i])) {
                this.jetty.setStopKey(args[++i]);
                continue;
            }
            if ("--jetty-xml".equals(args[i])) {
                ArrayList<File> jettyXmls = new ArrayList<File>();
                String[] names = StringUtil.csvSplit((String)args[++i]);
                for (int j = 0; names != null && j < names.length; ++j) {
                    jettyXmls.add(new File(names[j].trim()));
                }
                this.jetty.setJettyXmlFiles(jettyXmls);
                continue;
            }
            if ("--webprops".equals(args[i])) {
                this.webAppPropsFile = new File(args[++i].trim());
                this.jetty.setWebAppProperties(this.loadWebAppProps());
                continue;
            }
            if ("--token".equals(args[i])) {
                this.tokenFile = new File(args[++i].trim());
                continue;
            }
            if ("--scanInterval".equals(args[i])) {
                this.scanInterval = Integer.parseInt(args[++i].trim());
                this.scanner = new Scanner();
                this.scanner.setReportExistingFilesOnStartup(false);
                this.scanner.setScanInterval(this.scanInterval);
                this.scanner.addListener((Scanner.Listener)new Scanner.BulkListener(){

                    public void filesChanged(Set<String> changes) {
                        if (!Objects.isNull(JettyForkedChild.this.scanner)) {
                            try {
                                JettyForkedChild.this.scanner.stop();
                                if (!Objects.isNull((Object)JettyForkedChild.this.jetty.getWebApp())) {
                                    JettyForkedChild.this.jetty.getWebApp().stop();
                                    JettyForkedChild.this.jetty.setWebAppProperties(JettyForkedChild.this.loadWebAppProps());
                                    JettyForkedChild.this.jetty.setWebApp(JettyForkedChild.this.jetty.getWebApp());
                                    JettyForkedChild.this.jetty.redeployWebApp();
                                    JettyForkedChild.this.scanner.start();
                                }
                            }
                            catch (Exception e) {
                                LOG.error("Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                            }
                        }
                    }
                });
                if (Objects.isNull(this.webAppPropsFile)) continue;
                this.scanner.addFile(this.webAppPropsFile.toPath());
                continue;
            }
            String[] tmp = args[i].trim().split("=");
            if (tmp.length != 2) continue;
            jettyProperties.put(tmp[0], tmp[1]);
        }
        this.jetty.setJettyProperties(jettyProperties);
        this.jetty.setExitVm(true);
    }

    private Properties loadWebAppProps() throws IOException {
        Properties props = new Properties();
        if (Objects.nonNull(this.webAppPropsFile)) {
            props.load(new FileInputStream(this.webAppPropsFile));
        }
        return props;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.jetty.start();
        Path tokenPath = this.tokenFile.toPath();
        Files.createFile(tokenPath, new FileAttribute[0]);
        if (this.scanner != null) {
            this.scanner.start();
        }
        this.jetty.join();
    }

    public static void main(String[] args) throws Exception {
        if (args == null) {
            System.exit(1);
        }
        JettyForkedChild child = new JettyForkedChild(args);
        child.start();
    }
}

