/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.SelectorUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveJarResource
extends Resource {
    private static final Logger LOG = LoggerFactory.getLogger(SelectiveJarResource.class);
    public static final List<String> DEFAULT_INCLUDES = Arrays.asList("**");
    public static final List<String> DEFAULT_EXCLUDES = Collections.emptyList();
    final Resource _delegate;
    List<String> _includes = null;
    List<String> _excludes = null;
    boolean _caseSensitive = false;

    public SelectiveJarResource(Resource resource) {
        this._delegate = resource;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public void setIncludes(List<String> patterns) {
        this._includes = patterns;
    }

    public void setExcludes(List<String> patterns) {
        this._excludes = patterns;
    }

    protected boolean isIncluded(String name) {
        for (String include : this._includes) {
            if (!SelectorUtils.matchPath((String)include, (String)name, (String)"/", (boolean)this._caseSensitive)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        for (String exclude : this._excludes) {
            if (!SelectorUtils.matchPath((String)exclude, (String)name, (String)"/", (boolean)this._caseSensitive)) continue;
            return true;
        }
        return false;
    }

    public Path getPath() {
        return this._delegate.getPath();
    }

    public boolean isDirectory() {
        return this._delegate.isDirectory();
    }

    public Instant lastModified() {
        return this._delegate.lastModified();
    }

    public boolean isReadable() {
        return this._delegate.isReadable();
    }

    public boolean isContainedIn(Resource container) {
        return this._delegate.isContainedIn(container);
    }

    public boolean contains(Resource other) {
        return this._delegate.contains(other);
    }

    public Path getPathTo(Resource other) {
        return this._delegate.getPathTo(other);
    }

    public URI getURI() {
        return this._delegate.getURI();
    }

    public String getName() {
        return this._delegate.getName();
    }

    public String getFileName() {
        return this._delegate.getFileName();
    }

    public Resource resolve(String subUriPath) {
        return this._delegate.resolve(subUriPath);
    }

    public void copyTo(Path directory) throws IOException {
        block36: {
            int startOfJarUrl;
            if (this._includes == null) {
                this._includes = DEFAULT_INCLUDES;
            }
            if (this._excludes == null) {
                this._excludes = DEFAULT_EXCLUDES;
            }
            if (!this.exists()) {
                return;
            }
            String urlString = this.getURI().toASCIIString().trim();
            int endOfJarUrl = urlString.indexOf("!/");
            int n = startOfJarUrl = endOfJarUrl >= 0 ? 4 : 0;
            if (endOfJarUrl < 0) {
                throw new IOException("Not a valid jar url: " + urlString);
            }
            URL jarFileURL = new URL(urlString.substring(startOfJarUrl, endOfJarUrl));
            try (InputStream is = jarFileURL.openConnection().getInputStream();
                 JarInputStream jin = new JarInputStream(is);){
                OutputStream fout;
                JarEntry entry;
                while ((entry = jin.getNextJarEntry()) != null) {
                    String entryName = entry.getName();
                    LOG.debug("Looking at {}", (Object)entryName);
                    if (URIUtil.isNotNormalWithinSelf((String)entryName)) {
                        LOG.info("Invalid entry: {}", (Object)entryName);
                        continue;
                    }
                    Path file = directory.resolve(entryName);
                    if (entry.isDirectory()) {
                        if (this.isIncluded(entryName)) {
                            if (!this.isExcluded(entryName)) {
                                if (Files.exists(file, new LinkOption[0])) continue;
                                Files.createDirectories(file, new FileAttribute[0]);
                                continue;
                            }
                            LOG.debug("{} dir is excluded", (Object)entryName);
                            continue;
                        }
                        LOG.debug("{} dir is NOT included", (Object)entryName);
                        continue;
                    }
                    if (this.isIncluded(entryName)) {
                        if (!this.isExcluded(entryName)) {
                            Path dir = file.getParent();
                            if (!Files.exists(dir, new LinkOption[0])) {
                                Files.createDirectories(dir, new FileAttribute[0]);
                            }
                            fout = Files.newOutputStream(file, new OpenOption[0]);
                            try {
                                IO.copy((InputStream)jin, (OutputStream)fout);
                            }
                            finally {
                                if (fout != null) {
                                    fout.close();
                                }
                            }
                            if (entry.getTime() < 0L) continue;
                            Files.setLastModifiedTime(file, FileTime.fromMillis(entry.getTime()));
                            continue;
                        }
                        LOG.debug("{} file is excluded", (Object)entryName);
                        continue;
                    }
                    LOG.debug("{} file is NOT included", (Object)entryName);
                }
                Manifest manifest = jin.getManifest();
                if (manifest == null || !this.isIncluded("META-INF") || this.isExcluded("META-INF")) break block36;
                Path metaInf = directory.resolve("META-INF");
                Files.createDirectory(metaInf, new FileAttribute[0]);
                Path f = metaInf.resolve("MANIFEST.MF");
                fout = Files.newOutputStream(f, new OpenOption[0]);
                try {
                    manifest.write(fout);
                }
                finally {
                    if (fout != null) {
                        fout.close();
                    }
                }
            }
        }
    }
}

