/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.ee10.maven.plugin.AbstractWebAppMojo;
import org.eclipse.jetty.ee10.maven.plugin.ScanPattern;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;

public abstract class AbstractUnassembledWebAppMojo
extends AbstractWebAppMojo {
    @Parameter(defaultValue="${project.baseDir}/src/main/webapp/WEB-INF/web.xml")
    protected File webXml;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true)
    protected File testClassesDirectory;
    @Parameter
    protected ScanPattern scanTestClassesPattern;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classesDirectory;
    @Parameter
    protected ScanPattern scanClassesPattern;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp", readonly=true)
    protected File webAppSourceDirectory;

    @Override
    protected void verifyPomConfiguration() throws MojoExecutionException {
        if (!this.webAppSourceDirectory.exists()) {
            File target = new File(this.project.getBuild().getDirectory());
            this.webAppSourceDirectory = new File(target, "webapp-synth");
        }
        try {
            if (this.classesDirectory != null) {
                if (!this.classesDirectory.exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.classesDirectory.getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.classesDirectory.getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
    }

    @Override
    protected void configureWebApp() throws Exception {
        super.configureWebApp();
        try {
            this.configureUnassembledWebApp();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to configure unassembled webapp", (Throwable)e);
        }
    }

    protected void configureUnassembledWebApp() throws IOException {
        if (this.originalBaseResource == null) {
            if (this.webApp.getBaseResource() == null) {
                if (!this.webAppSourceDirectory.exists()) {
                    this.webAppSourceDirectory.mkdirs();
                }
                this.originalBaseResource = this.webApp.getResourceFactory().newResource(this.webAppSourceDirectory.getCanonicalPath());
            } else {
                this.originalBaseResource = this.webApp.getBaseResource();
            }
        }
        this.webApp.setBaseResource(this.originalBaseResource);
        if (this.webApp.getWar() == null) {
            this.webApp.setWar(this.originalBaseResource.toString());
        }
        if (this.classesDirectory != null) {
            this.webApp.setClasses(this.classesDirectory);
        }
        if (this.useTestScope && this.testClassesDirectory != null) {
            this.webApp.setTestClasses(this.testClassesDirectory);
        }
        List<File> webInfLibs = this.getWebInfLibArtifacts().stream().map(a -> {
            Path p = this.mavenProjectHelper.getPathFor((Artifact)a);
            this.getLog().debug((CharSequence)("Artifact " + a.getId() + " loaded from " + String.valueOf(p) + " added to WEB-INF/lib"));
            return p.toFile();
        }).collect(Collectors.toList());
        this.webApp.setWebInfLib(webInfLibs);
        if (this.webApp.getDescriptor() == null) {
            File f;
            Resource r;
            if (this.webXml != null && Resources.isReadableFile((Resource)(r = this.webApp.getResourceFactory().newResource(this.webXml.toPath())))) {
                this.webApp.setDescriptor(r.getURI().toASCIIString());
            }
            if (this.webApp.getDescriptor() == null && this.webApp.getBaseResource() != null && Resources.isReadableFile((Resource)(r = this.webApp.getBaseResource().resolve("WEB-INF/web.xml")))) {
                this.webApp.setDescriptor(r.getURI().toASCIIString());
            }
            if (this.webApp.getDescriptor() == null && this.webAppSourceDirectory != null && (f = new File(new File(this.webAppSourceDirectory, "WEB-INF"), "web.xml")).exists() && f.isFile()) {
                this.webApp.setDescriptor(f.getCanonicalPath());
            }
        }
        this.mavenProjectHelper.getOverlayManager().applyOverlays(this.webApp);
        this.getLog().info((CharSequence)("web.xml file = " + this.webApp.getDescriptor()));
        this.getLog().info((CharSequence)("Webapp directory = " + this.webAppSourceDirectory.getCanonicalPath()));
        this.getLog().info((CharSequence)("Web defaults = " + (this.webApp.getDefaultsDescriptor() == null ? " jetty default" : this.webApp.getDefaultsDescriptor())));
        this.getLog().info((CharSequence)("Web overrides = " + (this.webApp.getOverrideDescriptor() == null ? " none" : this.webApp.getOverrideDescriptor())));
    }

    protected Collection<Artifact> getWebInfLibArtifacts() {
        return this.project.getArtifacts().stream().filter(this::isArtifactOKForWebInfLib).collect(Collectors.toList());
    }

    private boolean isArtifactOKForWebInfLib(Artifact artifact) {
        if ("war".equalsIgnoreCase(artifact.getType())) {
            return false;
        }
        if ("provided".equals(artifact.getScope())) {
            return false;
        }
        return !"test".equals(artifact.getScope()) || this.useTestScope;
    }
}

