/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.plus.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee10.plus.jndi.EnvEntry;
import org.eclipse.jetty.ee10.plus.jndi.NamingDump;
import org.eclipse.jetty.ee10.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.jndi.ContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.jndi.local.localContextRoot;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvConfiguration
extends AbstractConfiguration {
    public static final String JETTY_ENV_XML = "org.eclipse.jetty.jndi.JettyEnvXml";
    private static final Logger LOG = LoggerFactory.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";

    public EnvConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(new Class[]{WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class}).addDependents(new Class[]{PlusConfiguration.class, JettyWebXmlConfiguration.class}).protectAndExpose(new String[]{"org.eclipse.jetty.jndi."}));
    }

    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnv;
        Resource webInf;
        Resource jettyEnvXmlResource;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp {}", (Object)context.getContextPath());
        }
        if ((jettyEnvXmlResource = (Resource)context.getAttribute(JETTY_ENV_XML)) == null && (webInf = context.getWebInf()) != null && webInf.isDirectory() && Resources.exists((Resource)(jettyEnv = webInf.resolve("jetty-env.xml")))) {
            jettyEnvXmlResource = jettyEnv;
        }
        if (jettyEnvXmlResource != null) {
            NamingContext namingContext = localContextRoot.getRoot();
            synchronized (namingContext) {
                final ArrayList bindings = new ArrayList();
                NamingContext.Listener listener = new NamingContext.Listener(){

                    public void unbind(NamingContext ctx, Binding binding) {
                    }

                    public Binding bind(NamingContext ctx, Binding binding) {
                        bindings.add(new Bound(ctx, binding.getName()));
                        return binding;
                    }
                };
                try {
                    localContextRoot.getRoot().addListener(listener);
                    XmlConfiguration configuration = new XmlConfiguration(jettyEnvXmlResource);
                    configuration.setJettyStandardIdsAndProperties((Object)context.getServer(), null);
                    WebAppClassLoader.runWithServerClassAccess(() -> {
                        configuration.configure((Object)context);
                        return null;
                    });
                }
                finally {
                    localContextRoot.getRoot().removeListener(listener);
                    context.setAttribute(JETTY_ENV_BINDINGS, bindings);
                }
            }
        }
        this.bindEnvEntries(context);
        context.addBean((Object)new NamingDump(context.getClassLoader(), "java:comp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deconfigure(WebAppContext context) throws Exception {
        Dumper dumper = (Dumper)context.getBean(Dumper.class);
        if (dumper != null) {
            context.removeBean((Object)dumper);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            List bindings = (List)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (bindings != null) {
                Collections.reverse(bindings);
                for (Bound b : bindings) {
                    b._context.destroySubcontext(b._name);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn("Unable to destroy InitialContext", (Throwable)e);
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingContext scopeContext = (NamingContext)NamingEntryUtil.getContextForScope(context);
            scopeContext.getParent().destroySubcontext(scopeContext.getName());
        }
        catch (NameNotFoundException e) {
            LOG.trace("IGNORED", (Throwable)e);
            LOG.debug("No jndi entries scoped to webapp {}", (Object)context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp {}", (Object)context, (Object)e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        LOG.debug("Binding env entries from the jvm scope");
        this.doBindings(envCtx, null);
        LOG.debug("Binding env entries from the server scope");
        this.doBindings(envCtx, context.getServer());
        LOG.debug("Binding env entries from environment {} scope", (Object)ServletContextHandler.__environment.getName());
        this.doBindings(envCtx, ServletContextHandler.__environment.getName());
        LOG.debug("Binding env entries from the context scope");
        this.doBindings(envCtx, context);
    }

    private void doBindings(Context envCtx, Object scope) throws NamingException {
        for (EnvEntry ee : NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class)) {
            ee.bindToENC(ee.getJndiName());
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind((Context)envCtx, (String)namingEntryName.toString(), (Object)ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        ContextFactory.associateClassLoader((ClassLoader)wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            ContextFactory.disassociateClassLoader();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private static class Dumper
    extends NamingDump {
        Dumper(ClassLoader loader, String name) {
            super(loader, name);
        }
    }

    private static class Bound {
        final NamingContext _context;
        final String _name;

        Bound(NamingContext context, String name) {
            this._context = context;
            this._name = name;
        }
    }
}

