/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.InvalidPathException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferInputStream;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);
    private ServletContextHandler _contextHandler;
    private ServletResourceService _resourceService;
    private WelcomeServletMode _welcomeServletMode;
    private Resource _baseResource;
    private boolean _isPathInfoOnly;

    public ResourceService getResourceService() {
        return this._resourceService;
    }

    public void init() throws ServletException {
        String cc;
        int encodingHeaderCacheSize;
        this._contextHandler = this.initContextHandler(this.getServletContext());
        this._resourceService = new ServletResourceService(this._contextHandler);
        this._resourceService.setWelcomeFactory(this._resourceService);
        this._baseResource = this._contextHandler.getBaseResource();
        String rb = this.getInitParameter("baseResource", "resourceBase");
        if (rb != null) {
            try {
                this._baseResource = Objects.requireNonNull(this._contextHandler.newResource(rb));
            }
            catch (Exception e) {
                LOG.warn("Unable to create baseResource from {}", (Object)rb, (Object)e);
                throw new UnavailableException(e.toString());
            }
        }
        List<CompressedContentFormat> precompressedFormats = this.parsePrecompressedFormats(this.getInitParameter("precompressed"), this.getInitBoolean("gzip"), this._resourceService.getPrecompressedFormats());
        HttpContent.Factory contentFactory = (HttpContent.Factory)this.getServletContext().getAttribute(HttpContent.Factory.class.getName());
        if (contentFactory == null) {
            long cacheValidationTime;
            MimeTypes.Mutable mimeTypes = this._contextHandler.getMimeTypes();
            ResourceFactory resourceFactory = this._baseResource != null ? ResourceFactory.of((Resource)this._baseResource) : this::getResource;
            contentFactory = new ResourceHttpContentFactory(resourceFactory, (MimeTypes)mimeTypes);
            Object styleSheet = this._contextHandler.getServer().getDefaultStyleSheet();
            String stylesheetParam = this.getInitParameter("stylesheet");
            if (stylesheetParam != null) {
                try {
                    Resource s;
                    HttpContent styleSheetContent = contentFactory.getContent(stylesheetParam);
                    Resource resource = s = styleSheetContent == null ? null : styleSheetContent.getResource();
                    if (Resources.isReadableFile((Resource)s)) {
                        styleSheet = s;
                    } else {
                        LOG.warn("Stylesheet {} does not exist", (Object)stylesheetParam);
                    }
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Unable to use stylesheet: {}", (Object)stylesheetParam, (Object)e);
                    }
                    LOG.warn("Unable to use stylesheet: {} - {}", (Object)stylesheetParam, (Object)e.toString());
                }
            }
            if (this.getInitBoolean("useFileMappedBuffer", false)) {
                contentFactory = new FileMappingHttpContentFactory(contentFactory);
            }
            contentFactory = new VirtualHttpContentFactory(contentFactory, (Resource)styleSheet, "text/css");
            contentFactory = new PreCompressedHttpContentFactory(contentFactory, precompressedFormats);
            int maxCacheSize = this.getInitInt("maxCacheSize", -2);
            int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
            int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
            long l = cacheValidationTime = this.getInitParameter("cacheValidationTime") != null ? Long.parseLong(this.getInitParameter("cacheValidationTime")) : -2L;
            if (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2 || cacheValidationTime != -2L) {
                ByteBufferPool bufferPool = DefaultServlet.getByteBufferPool(this._contextHandler);
                ValidatingCachingHttpContentFactory cached = new ValidatingCachingHttpContentFactory(contentFactory, cacheValidationTime > -2L ? cacheValidationTime : Duration.ofSeconds(1L).toMillis(), bufferPool);
                contentFactory = cached;
                if (maxCacheSize >= 0) {
                    cached.setMaxCacheSize((long)maxCacheSize);
                }
                if (maxCachedFileSize >= 0) {
                    cached.setMaxCachedFileSize(maxCachedFileSize);
                }
                if (maxCachedFiles >= 0) {
                    cached.setMaxCachedFiles(maxCachedFiles);
                }
            }
        }
        this._resourceService.setHttpContentFactory(contentFactory);
        if (this._contextHandler.getWelcomeFiles() == null) {
            this._contextHandler.setWelcomeFiles(new String[]{"index.html", "index.jsp"});
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        boolean redirectWelcome = this.getInitBoolean("redirectWelcome", false);
        this._resourceService.setWelcomeMode(redirectWelcome ? ResourceService.WelcomeMode.REDIRECT : ResourceService.WelcomeMode.SERVE);
        this._resourceService.setPrecompressedFormats(precompressedFormats);
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        this._isPathInfoOnly = this.getInitBoolean("pathInfoOnly", this._isPathInfoOnly);
        this._welcomeServletMode = WelcomeServletMode.NONE;
        String welcomeServlets = this.getInitParameter("welcomeServlets");
        if (welcomeServlets != null) {
            welcomeServlets = welcomeServlets.toLowerCase(Locale.ENGLISH);
            switch (welcomeServlets) {
                case "true": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.MATCH;
                    break;
                }
                case "exact": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.EXACT;
                    break;
                }
                default: {
                    WelcomeServletMode welcomeServletMode = this._welcomeServletMode = WelcomeServletMode.NONE;
                }
            }
        }
        if ((encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1)) >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl(cc);
        }
        ArrayList<Object> gzipEquivalentFileExtensions = new ArrayList<Object>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
        if (LOG.isDebugEnabled()) {
            LOG.debug("  .baseResource = {}", (Object)this._baseResource);
            LOG.debug("  .resourceService = {}", (Object)this._resourceService);
            LOG.debug("  .isPathInfoOnly = {}", (Object)this._isPathInfoOnly);
            LOG.debug("  .welcomeServletMode = {}", (Object)this._welcomeServletMode);
        }
    }

    private static ByteBufferPool getByteBufferPool(ContextHandler contextHandler) {
        if (contextHandler == null) {
            return new ByteBufferPool.NonPooling();
        }
        Server server = contextHandler.getServer();
        if (server == null) {
            return new ByteBufferPool.NonPooling();
        }
        return server.getByteBufferPool();
    }

    private String getInitParameter(String name, String ... deprecated) {
        String value = super.getInitParameter(name);
        if (value != null) {
            return value;
        }
        for (String d : deprecated) {
            value = super.getInitParameter(d);
            if (value == null) continue;
            LOG.warn("Deprecated {} used instead of {}", (Object)d, (Object)name);
            return value;
        }
        return null;
    }

    private List<CompressedContentFormat> parsePrecompressedFormats(String precompressed, Boolean gzip, List<CompressedContentFormat> dft) {
        if (precompressed == null && gzip == null) {
            return dft;
        }
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String pair : precompressed.split(",")) {
                String[] setting = pair.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (gzip != Boolean.TRUE || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            if (Boolean.parseBoolean(precompressed)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (gzip == Boolean.TRUE) {
            ret.add(CompressedContentFormat.GZIP);
        }
        return ret;
    }

    private Boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private boolean getInitBoolean(String name, boolean dft) {
        return Optional.ofNullable(this.getInitBoolean(name)).orElse(dft);
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    protected ServletContextHandler initContextHandler(ServletContext servletContext) {
        if (servletContext instanceof ServletContextHandler.ServletContextApi) {
            ServletContextHandler.ServletContextApi api = (ServletContextHandler.ServletContextApi)servletContext;
            return api.getContext().getServletContextHandler();
        }
        Context context = ContextHandler.getCurrentContext();
        if (context instanceof ContextHandler.ScopedContext) {
            ContextHandler.ScopedContext scopedContext = (ContextHandler.ScopedContext)context;
            return (ServletContextHandler)scopedContext.getContextHandler();
        }
        throw new IllegalArgumentException("The servletContext " + String.valueOf(servletContext) + " " + servletContext.getClass().getName() + " is not " + ContextHandler.ScopedContext.class.getName());
    }

    protected boolean isPathInfoOnly() {
        return this._isPathInfoOnly;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block26: {
            String encodedPathInContext;
            boolean included;
            String includedServletPath = (String)req.getAttribute("jakarta.servlet.include.servlet_path");
            boolean bl = included = includedServletPath != null;
            if (included) {
                encodedPathInContext = URIUtil.encodePath((String)DefaultServlet.getIncludedPathInContext(req, includedServletPath, this.isPathInfoOnly()));
            } else if (this.isPathInfoOnly()) {
                encodedPathInContext = URIUtil.encodePath((String)req.getPathInfo());
            } else if (req instanceof ServletApiRequest) {
                ServletApiRequest apiRequest = (ServletApiRequest)req;
                encodedPathInContext = Context.getPathInContext((String)req.getContextPath(), (String)apiRequest.getRequest().getHttpURI().getCanonicalPath());
            } else {
                encodedPathInContext = Context.getPathInContext((String)req.getContextPath(), (String)URIUtil.canonicalPath((String)req.getRequestURI()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("doGet(req={}, resp={}) pathInContext={}, included={}", new Object[]{req, resp, encodedPathInContext, included});
            }
            try {
                String characterEncoding;
                ServletContextResponse contextResponse;
                Object content = this._resourceService.getContent(encodedPathInContext, (Request)ServletContextRequest.getServletContextRequest((ServletRequest)req));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("content = {}", content);
                }
                if (content == null || Resources.missing((Resource)content.getResource())) {
                    if (included) {
                        throw new FileNotFoundException(encodedPathInContext);
                    }
                    resp.sendError(404);
                    break block26;
                }
                ServletCoreRequest coreRequest = new ServletCoreRequest(req);
                ServletCoreResponse coreResponse = new ServletCoreResponse(coreRequest, resp, included);
                if (coreResponse.isCommitted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Response already committed for {}", (Object)coreRequest.getHttpURI());
                    }
                    return;
                }
                if (coreResponse.isHttpServletResponseWrapped() || coreResponse.isWritingOrStreaming()) {
                    content = new UnknownLengthHttpContent((HttpContent)content);
                }
                if ((contextResponse = coreResponse.getServletContextResponse()) != null && (characterEncoding = contextResponse.getRawCharacterEncoding()) != null) {
                    content = new ForcedCharacterEncodingHttpContent((HttpContent)content, characterEncoding);
                }
                try (Blocker.Callback callback = Blocker.callback();){
                    this._resourceService.doGet((Request)coreRequest, coreResponse, (Callback)callback, (HttpContent)content);
                    callback.block();
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (InvalidPathException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("InvalidPathException for pathInContext: {}", (Object)encodedPathInContext, (Object)e);
                }
                if (included) {
                    throw new FileNotFoundException(encodedPathInContext);
                }
                resp.setStatus(404);
            }
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doHead(req={}, resp={}) (calling doGet())", (Object)req, (Object)resp);
        }
        this.doGet(req, resp);
    }

    private Resource getResource(URI uri) {
        String uriPath = uri.getRawPath();
        Resource result = null;
        try {
            result = this._contextHandler.getResource(uriPath);
        }
        catch (IOException x) {
            LOG.trace("IGNORED", (Throwable)x);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource {}={}", (Object)uriPath, (Object)result);
        }
        return result;
    }

    private static String getIncludedPathInContext(HttpServletRequest request, String includedServletPath, boolean isPathInfoOnly) {
        String servletPath = isPathInfoOnly ? "/" : includedServletPath;
        String pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
        return URIUtil.addPaths((String)servletPath, (String)pathInfo);
    }

    private static boolean isIncluded(HttpServletRequest request) {
        return request.getAttribute("jakarta.servlet.include.request_uri") != null;
    }

    private class ServletResourceService
    extends ResourceService
    implements ResourceService.WelcomeFactory {
        private final ServletContextHandler _servletContextHandler;

        private ServletResourceService(ServletContextHandler servletContextHandler) {
            this._servletContextHandler = servletContextHandler;
        }

        public String getWelcomeTarget(HttpContent content, Request coreRequest) {
            String[] welcomes = this._servletContextHandler.getWelcomeFiles();
            if (welcomes == null) {
                return null;
            }
            String pathInContext = Request.getPathInContext((Request)coreRequest);
            String welcomeTarget = null;
            Resource base = content.getResource();
            if (Resources.isReadableDirectory((Resource)base)) {
                for (String welcome : welcomes) {
                    ServletHandler.MappedServlet entry;
                    String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)welcome);
                    Resource welcomePath = content.getResource().resolve(welcome);
                    if (Resources.isReadableFile((Resource)welcomePath)) {
                        return welcomeInContext;
                    }
                    if (DefaultServlet.this._welcomeServletMode == WelcomeServletMode.NONE || welcomeTarget != null) continue;
                    if (DefaultServlet.this.isPathInfoOnly() && !DefaultServlet.isIncluded(this.getServletRequest(coreRequest))) {
                        welcomeTarget = URIUtil.addPaths((String)this.getServletRequest(coreRequest).getPathInfo(), (String)welcome);
                    }
                    if ((entry = this._servletContextHandler.getServletHandler().getMappedServlet(welcomeInContext)) == null || entry.getServletHolder().getServletInstance() == DefaultServlet.this || DefaultServlet.this._welcomeServletMode != WelcomeServletMode.MATCH && !entry.getPathSpec().getDeclaration().equals(welcomeInContext)) continue;
                    welcomeTarget = welcomeInContext;
                }
            }
            return welcomeTarget;
        }

        protected void redirectWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            String servletPath;
            HttpServletRequest servletRequest = this.getServletRequest(request);
            HttpServletResponse servletResponse = this.getServletResponse(response);
            boolean included = DefaultServlet.isIncluded(servletRequest);
            String string = servletPath = included ? (String)servletRequest.getAttribute("jakarta.servlet.include.servlet_path") : servletRequest.getServletPath();
            if (DefaultServlet.this.isPathInfoOnly()) {
                welcomeTarget = URIUtil.addPaths((String)servletPath, (String)welcomeTarget);
            }
            servletResponse.setContentLength(0);
            Response.sendRedirect((Request)request, (Response)response, (Callback)callback, (String)welcomeTarget);
        }

        protected void serveWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            HttpServletRequest servletRequest = this.getServletRequest(request);
            HttpServletResponse servletResponse = this.getServletResponse(response);
            boolean included = DefaultServlet.isIncluded(servletRequest);
            RequestDispatcher dispatcher = servletRequest.getServletContext().getRequestDispatcher(welcomeTarget);
            if (dispatcher == null) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500);
                return;
            }
            try {
                if (included) {
                    dispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                } else {
                    servletRequest.setAttribute("org.eclipse.jetty.server.welcome", (Object)welcomeTarget);
                    dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                }
                callback.succeeded();
            }
            catch (ServletException e) {
                callback.failed((Throwable)e);
            }
        }

        protected void rehandleWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            this.serveWelcome(request, response, callback, welcomeTarget);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={})", new Object[]{coreRequest, coreResponse, callback, statusCode});
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, null, null);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, cause={})", new Object[]{coreRequest, coreResponse, callback, cause, cause});
            }
            int statusCode = 500;
            String reason = null;
            if (cause instanceof HttpException) {
                HttpException httpException = (HttpException)cause;
                statusCode = httpException.getCode();
                reason = httpException.getReason();
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, reason, cause);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode, String reason, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={}, reason={}, cause={})", new Object[]{coreRequest, coreResponse, callback, statusCode, reason, cause, cause});
            }
            HttpServletRequest request = this.getServletRequest(coreRequest);
            HttpServletResponse response = this.getServletResponse(coreResponse);
            try {
                if (DefaultServlet.isIncluded(request)) {
                    return;
                }
                if (cause != null) {
                    request.setAttribute("jakarta.servlet.error.exception", (Object)cause);
                }
                response.sendError(statusCode, reason);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                callback.succeeded();
            }
        }

        protected boolean passConditionalHeaders(Request request, Response response, HttpContent content, Callback callback) throws IOException {
            boolean included = DefaultServlet.isIncluded(this.getServletRequest(request));
            if (included) {
                return false;
            }
            return super.passConditionalHeaders(request, response, content, callback);
        }

        private HttpServletRequest getServletRequest(Request request) {
            return ((ServletCoreRequest)request)._servletRequest;
        }

        private HttpServletResponse getServletResponse(Response response) {
            return ((ServletCoreResponse)response)._response;
        }
    }

    private static enum WelcomeServletMode {
        NONE,
        MATCH,
        EXACT;

    }

    private static class ServletCoreRequest
    extends Request.Wrapper {
        private final HttpServletRequest _servletRequest;
        private final HttpFields _httpFields;
        private final HttpURI _uri;

        ServletCoreRequest(HttpServletRequest request) {
            super((Request)ServletContextRequest.getServletContextRequest((ServletRequest)request));
            boolean included;
            this._servletRequest = request;
            HttpFields.Mutable fields = HttpFields.build();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    fields.add(new HttpField(headerName, headerValue));
                }
            }
            this._httpFields = fields.asImmutable();
            String includedServletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
            boolean bl = included = includedServletPath != null;
            this._uri = request.getDispatcherType() == DispatcherType.REQUEST ? this.getWrapped().getHttpURI() : (included ? Request.newHttpURIFrom((Request)this.getWrapped(), (String)URIUtil.encodePath((String)DefaultServlet.getIncludedPathInContext(request, includedServletPath, false))) : Request.newHttpURIFrom((Request)this.getWrapped(), (String)URIUtil.encodePath((String)URIUtil.addPaths((String)this._servletRequest.getServletPath(), (String)this._servletRequest.getPathInfo()))));
        }

        public HttpFields getHeaders() {
            return this._httpFields;
        }

        public HttpURI getHttpURI() {
            return this._uri;
        }

        public String getId() {
            return this._servletRequest.getRequestId();
        }

        public String getMethod() {
            return this._servletRequest.getMethod();
        }

        public boolean isSecure() {
            return this._servletRequest.isSecure();
        }

        public Object removeAttribute(String name) {
            Object value = this._servletRequest.getAttribute(name);
            this._servletRequest.removeAttribute(name);
            return value;
        }

        public Object setAttribute(String name, Object attribute) {
            Object value = this._servletRequest.getAttribute(name);
            this._servletRequest.setAttribute(name, attribute);
            return value;
        }

        public Object getAttribute(String name) {
            return this._servletRequest.getAttribute(name);
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration e = this._servletRequest.getAttributeNames();
            while (e.hasMoreElements()) {
                set.add((String)e.nextElement());
            }
            return set;
        }

        public void clearAttributes() {
            Enumeration e = this._servletRequest.getAttributeNames();
            while (e.hasMoreElements()) {
                this._servletRequest.removeAttribute((String)e.nextElement());
            }
        }
    }

    private static class ServletCoreResponse
    implements Response {
        private final HttpServletResponse _response;
        private final ServletCoreRequest _coreRequest;
        private final Response _coreResponse;
        private final HttpFields.Mutable _httpFields;
        private final boolean _included;

        public ServletCoreResponse(ServletCoreRequest coreRequest, HttpServletResponse response, boolean included) {
            this._coreRequest = coreRequest;
            this._response = response;
            this._coreResponse = ServletContextResponse.getServletContextResponse((ServletResponse)response);
            HttpServletResponseHttpFields fields = new HttpServletResponseHttpFields(response);
            if (included) {
                fields = new HttpFields.Mutable.Wrapper(fields){

                    public HttpField onAddField(HttpField field) {
                        return null;
                    }

                    public boolean onRemoveField(HttpField field) {
                        return false;
                    }
                };
            }
            this._httpFields = fields;
            this._included = included;
        }

        public HttpFields.Mutable getHeaders() {
            return this._httpFields;
        }

        public ServletContextResponse getServletContextResponse() {
            return ServletContextResponse.getServletContextResponse((ServletResponse)this._response);
        }

        public boolean isCommitted() {
            return this._response.isCommitted();
        }

        public boolean isHttpServletResponseWrapped() {
            return this._response instanceof HttpServletResponseWrapper;
        }

        public boolean isWritingOrStreaming() {
            ServletContextResponse servletContextResponse = (ServletContextResponse)Response.as((Response)this._coreResponse, ServletContextResponse.class);
            return servletContextResponse.isWritingOrStreaming();
        }

        public boolean isWriting() {
            ServletContextResponse servletContextResponse = (ServletContextResponse)Response.as((Response)this._coreResponse, ServletContextResponse.class);
            return servletContextResponse.isWriting();
        }

        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            if (this._included) {
                last = false;
            }
            try {
                if (BufferUtil.hasContent((ByteBuffer)byteBuffer)) {
                    if (this.isWriting()) {
                        String characterEncoding = this._response.getCharacterEncoding();
                        try (ByteBufferInputStream bbis = new ByteBufferInputStream(byteBuffer);
                             InputStreamReader reader = new InputStreamReader((InputStream)bbis, characterEncoding);){
                            IO.copy((Reader)reader, (Writer)this._response.getWriter());
                        }
                        if (last) {
                            this._response.getWriter().close();
                        }
                    } else {
                        BufferUtil.writeTo((ByteBuffer)byteBuffer, (OutputStream)this._response.getOutputStream());
                        if (last) {
                            this._response.getOutputStream().close();
                        }
                    }
                }
                callback.succeeded();
            }
            catch (Throwable t) {
                callback.failed(t);
            }
        }

        public Request getRequest() {
            return this._coreRequest;
        }

        public int getStatus() {
            return this._response.getStatus();
        }

        public void setStatus(int code) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}.setStatus({})", (Object)this.getClass().getSimpleName(), (Object)code);
            }
            if (this._included) {
                return;
            }
            this._response.setStatus(code);
        }

        public Supplier<HttpFields> getTrailersSupplier() {
            return null;
        }

        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
        }

        public boolean isCompletedSuccessfully() {
            return this._coreResponse.isCompletedSuccessfully();
        }

        public void reset() {
            this._response.reset();
        }

        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            return null;
        }

        public String toString() {
            return "%s@%x{%s,%s}".formatted(new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._coreRequest, this._response});
        }
    }

    private static class UnknownLengthHttpContent
    extends HttpContent.Wrapper {
        public UnknownLengthHttpContent(HttpContent content) {
            super(content);
        }

        public HttpField getContentLength() {
            return null;
        }

        public long getContentLengthValue() {
            return -1L;
        }
    }

    private static class ForcedCharacterEncodingHttpContent
    extends HttpContent.Wrapper {
        private final String characterEncoding;
        private final String contentType;

        public ForcedCharacterEncodingHttpContent(HttpContent content, String characterEncoding) {
            super(Objects.requireNonNull(content));
            this.characterEncoding = characterEncoding;
            if (content.getContentTypeValue() == null || content.getResource().isDirectory()) {
                this.contentType = null;
            } else {
                String mimeType = content.getContentTypeValue();
                int idx = mimeType.indexOf(";charset");
                if (idx >= 0) {
                    mimeType = mimeType.substring(0, idx);
                }
                this.contentType = mimeType + ";charset=" + characterEncoding;
            }
        }

        public HttpField getContentType() {
            return new HttpField(HttpHeader.CONTENT_TYPE, this.contentType);
        }

        public String getContentTypeValue() {
            return this.contentType;
        }

        public String getCharacterEncoding() {
            return this.characterEncoding;
        }
    }

    private static class HttpServletResponseHttpFields
    implements HttpFields.Mutable {
        private final HttpServletResponse _response;

        private HttpServletResponseHttpFields(HttpServletResponse response) {
            this._response = response;
        }

        public ListIterator<HttpField> listIterator() {
            final ListIterator list = this._response.getHeaderNames().stream().map(n -> new HttpField(n, this._response.getHeader(n))).collect(Collectors.toList()).listIterator();
            return new ListIterator<HttpField>(){
                HttpField _last;

                @Override
                public boolean hasNext() {
                    return list.hasNext();
                }

                @Override
                public HttpField next() {
                    this._last = (HttpField)list.next();
                    return this._last;
                }

                @Override
                public boolean hasPrevious() {
                    return list.hasPrevious();
                }

                @Override
                public HttpField previous() {
                    this._last = (HttpField)list.previous();
                    return this._last;
                }

                @Override
                public int nextIndex() {
                    return list.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return list.previousIndex();
                }

                @Override
                public void remove() {
                    if (this._last != null) {
                        list.remove();
                        _response.setHeader(this._last.getName(), null);
                    }
                }

                @Override
                public void set(HttpField httpField) {
                    list.set(httpField);
                    _response.setHeader(httpField.getName(), httpField.getValue());
                }

                @Override
                public void add(HttpField httpField) {
                    list.add(httpField);
                    _response.addHeader(httpField.getName(), httpField.getValue());
                }
            };
        }

        public HttpFields.Mutable add(String name, String value) {
            this._response.addHeader(name, value);
            return this;
        }

        public HttpFields.Mutable add(HttpHeader header, HttpHeaderValue value) {
            this._response.addHeader(header.asString(), value.asString());
            return this;
        }

        public HttpFields.Mutable add(HttpHeader header, String value) {
            this._response.addHeader(header.asString(), value);
            return this;
        }

        public HttpFields.Mutable add(HttpField field) {
            this._response.addHeader(field.getName(), field.getValue());
            return this;
        }

        public HttpFields.Mutable put(HttpField field) {
            this._response.setHeader(field.getName(), field.getValue());
            return this;
        }

        public HttpFields.Mutable put(String name, String value) {
            this._response.setHeader(name, value);
            return this;
        }

        public HttpFields.Mutable put(HttpHeader header, HttpHeaderValue value) {
            this._response.setHeader(header.asString(), value.asString());
            return this;
        }

        public HttpFields.Mutable put(HttpHeader header, String value) {
            this._response.setHeader(header.asString(), value);
            return this;
        }

        public HttpFields.Mutable put(String name, List<String> list) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(list);
            boolean first = true;
            for (String s : list) {
                if (first) {
                    this._response.setHeader(name, s);
                } else {
                    this._response.addHeader(name, s);
                }
                first = false;
            }
            return this;
        }

        public HttpFields.Mutable remove(HttpHeader header) {
            this._response.setHeader(header.asString(), null);
            return this;
        }

        public HttpFields.Mutable remove(EnumSet<HttpHeader> fields) {
            for (HttpHeader header : fields) {
                this.remove(header);
            }
            return this;
        }

        public HttpFields.Mutable remove(String name) {
            this._response.setHeader(name, null);
            return this;
        }
    }
}

