/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;

public class AsyncContextState
implements AsyncContext {
    volatile ServletRequestState _state;

    public AsyncContextState(ServletRequestState state) {
        this._state = state;
    }

    ServletRequestState state() {
        ServletRequestState state = this._state;
        if (state == null) {
            throw new IllegalStateException("AsyncContext completed and/or Request lifecycle recycled");
        }
        return state;
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        WrappedAsyncListener wrap = new WrappedAsyncListener(listener, request, response);
        this.state().addListener(wrap);
    }

    public void addListener(AsyncListener listener) {
        this.state().addListener(listener);
    }

    public void complete() {
        this.state().complete();
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)this.state().getContextHandler().getContext().getServletContext().createInstance(clazz));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void dispatch() {
        this.state().dispatch(null, null);
    }

    public void dispatch(String path) {
        this.state().dispatch(null, path);
    }

    public void dispatch(ServletContext context, String path) {
        this.state().dispatch(context, path);
    }

    public ServletRequest getRequest() {
        return this.state().getAsyncContextEvent().getSuppliedRequest();
    }

    public ServletResponse getResponse() {
        return this.state().getAsyncContextEvent().getSuppliedResponse();
    }

    public long getTimeout() {
        return this.state().getTimeout();
    }

    public boolean hasOriginalRequestAndResponse() {
        ServletRequest servletRequest = this.getRequest();
        ServletResponse servletResponse = this.getResponse();
        ServletChannel servletChannel = this._state.getServletChannel();
        ServletApiRequest originalHttpServletRequest = servletChannel.getServletContextRequest().getServletApiRequest();
        ServletApiResponse originalHttpServletResponse = servletChannel.getServletContextResponse().getServletApiResponse();
        return servletRequest == originalHttpServletRequest && servletResponse == originalHttpServletResponse;
    }

    public void setTimeout(long timeout) {
        this.state().setTimeout(timeout);
    }

    public void start(Runnable task) {
        this._state.getServletChannel().getContext().execute(() -> {
            AsyncContextEvent asyncContextEvent = this.state().getAsyncContextEvent();
            if (asyncContextEvent != null && asyncContextEvent.getContext() != null) {
                asyncContextEvent.getContext().run(task);
            } else {
                task.run();
            }
        });
    }

    public void reset() {
        this._state = null;
    }

    public ServletRequestState getServletChannelState() {
        return this.state();
    }

    public static class WrappedAsyncListener
    implements AsyncListener {
        private final AsyncListener _listener;
        private final ServletRequest _request;
        private final ServletResponse _response;

        public WrappedAsyncListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
            this._listener = listener;
            this._request = request;
            this._response = response;
        }

        public AsyncListener getListener() {
            return this._listener;
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this._listener.onTimeout(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this._listener.onStartAsync(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        public void onError(AsyncEvent event) throws IOException {
            this._listener.onError(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }

        public void onComplete(AsyncEvent event) throws IOException {
            this._listener.onComplete(new AsyncEvent(event.getAsyncContext(), this._request, this._response, event.getThrowable()));
        }
    }
}

