/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.MappingMatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletCoreRequest;
import org.eclipse.jetty.ee10.servlet.ServletCoreResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.FileMappingHttpContentFactory;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.PreCompressedHttpContentFactory;
import org.eclipse.jetty.http.content.ResourceHttpContentFactory;
import org.eclipse.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.eclipse.jetty.http.content.VirtualHttpContentFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.AllowedResourceAliasChecker;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private ServletResourceService _resourceService;
    private WelcomeServletMode _welcomeServletMode;
    private boolean _pathInfoOnly;
    private ByteBufferPool.Sized _bufferPool;

    public ResourceService getResourceService() {
        return this._resourceService;
    }

    public void init() throws ServletException {
        String cc;
        int encodingHeaderCacheSize;
        ServletContextHandler contextHandler = this.initContextHandler(this.getServletContext());
        this._resourceService = new ServletResourceService(contextHandler);
        this._resourceService.setWelcomeFactory(this._resourceService);
        Resource baseResource = contextHandler.getBaseResource();
        String rb = this.getInitParameter("baseResource", "resourceBase");
        if (rb != null) {
            try {
                Resource resource = baseResource = URIUtil.isRelative((String)rb) ? baseResource.resolve(rb) : contextHandler.newResource(rb);
                if (baseResource.isAlias()) {
                    baseResource = contextHandler.newResource(baseResource.getRealURI());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to create baseResource from {}", (Object)rb, (Object)e);
                throw new UnavailableException(e.toString());
            }
        }
        if (!(baseResource == null || baseResource.isDirectory() && baseResource.isReadable())) {
            LOG.warn("baseResource {} is not a readable directory", (Object)baseResource);
        }
        if (this.getInitBoolean("installAllowedResourceAliasChecker", true)) {
            boolean addAliasCheck = true;
            for (AliasCheck aliasCheck : contextHandler.getAliasChecks()) {
                AllowedResourceAliasChecker allowedResourceAliasChecker;
                if (!(aliasCheck instanceof AllowedResourceAliasChecker) || !Objects.equals(baseResource, (allowedResourceAliasChecker = (AllowedResourceAliasChecker)aliasCheck).getBaseResource())) continue;
                addAliasCheck = false;
                break;
            }
            if (addAliasCheck) {
                contextHandler.addAliasCheck((AliasCheck)new AllowedResourceAliasChecker((ContextHandler)contextHandler, baseResource));
            }
        }
        List<CompressedContentFormat> precompressedFormats = this.parsePrecompressedFormats(this.getInitParameter("precompressed"), this.getInitBoolean("gzip"), this._resourceService.getPrecompressedFormats());
        HttpContent.Factory contentFactory = (HttpContent.Factory)this.getServletContext().getAttribute(HttpContent.Factory.class.getName());
        if (contentFactory == null) {
            long cacheValidationTime;
            MimeTypes.Mutable mimeTypes = contextHandler.getMimeTypes();
            ByteBufferPool.Sized bufferPool = this.getByteBufferPool(contextHandler);
            contentFactory = new ResourceHttpContentFactory(baseResource, (MimeTypes)mimeTypes, bufferPool);
            Object styleSheet = contextHandler.getServer().getDefaultStyleSheet();
            String stylesheetParam = this.getInitParameter("stylesheet");
            if (stylesheetParam != null) {
                try {
                    Resource s;
                    HttpContent styleSheetContent = contentFactory.getContent(stylesheetParam);
                    Resource resource = s = styleSheetContent == null ? null : styleSheetContent.getResource();
                    if (Resources.isReadableFile((Resource)s)) {
                        styleSheet = s;
                    } else {
                        LOG.warn("Stylesheet {} does not exist", (Object)stylesheetParam);
                    }
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Unable to use stylesheet: {}", (Object)stylesheetParam, (Object)e);
                    }
                    LOG.warn("Unable to use stylesheet: {} - {}", (Object)stylesheetParam, (Object)e.toString());
                }
            }
            if (this.getInitBoolean("useFileMappedBuffer", false)) {
                contentFactory = new FileMappingHttpContentFactory(contentFactory);
            }
            contentFactory = new VirtualHttpContentFactory(contentFactory, (Resource)styleSheet, "text/css", bufferPool);
            contentFactory = new PreCompressedHttpContentFactory(contentFactory, precompressedFormats);
            int maxCacheSize = this.getInitInt("maxCacheSize", -2);
            int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
            int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
            long l = cacheValidationTime = this.getInitParameter("cacheValidationTime") != null ? Long.parseLong(this.getInitParameter("cacheValidationTime")) : -2L;
            if (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2 || cacheValidationTime != -2L) {
                ValidatingCachingHttpContentFactory cached = new ValidatingCachingHttpContentFactory(contentFactory, cacheValidationTime > -2L ? cacheValidationTime : Duration.ofSeconds(1L).toMillis(), bufferPool);
                contentFactory = cached;
                if (maxCacheSize >= 0) {
                    cached.setMaxCacheSize((long)maxCacheSize);
                }
                if (maxCachedFileSize >= 0) {
                    cached.setMaxCachedFileSize(maxCachedFileSize);
                }
                if (maxCachedFiles >= 0) {
                    cached.setMaxCachedFiles(maxCachedFiles);
                }
            }
        }
        this._resourceService.setHttpContentFactory(contentFactory);
        if (contextHandler.getWelcomeFiles() == null) {
            contextHandler.setWelcomeFiles(new String[]{"index.html", "index.jsp"});
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        boolean redirectWelcome = this.getInitBoolean("redirectWelcome", false);
        this._resourceService.setWelcomeMode(redirectWelcome ? ResourceService.WelcomeMode.REDIRECT : ResourceService.WelcomeMode.SERVE);
        this._resourceService.setPrecompressedFormats(precompressedFormats);
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        this._welcomeServletMode = WelcomeServletMode.NONE;
        String welcomeServlets = this.getInitParameter("welcomeServlets");
        if (welcomeServlets != null) {
            welcomeServlets = welcomeServlets.toLowerCase(Locale.ENGLISH);
            switch (welcomeServlets) {
                case "true": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.MATCH;
                    break;
                }
                case "exact": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.EXACT;
                    break;
                }
                default: {
                    WelcomeServletMode welcomeServletMode = this._welcomeServletMode = WelcomeServletMode.NONE;
                }
            }
        }
        if ((encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1)) >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl(cc);
        }
        ArrayList<Object> gzipEquivalentFileExtensions = new ArrayList<Object>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
        this._pathInfoOnly = this.getInitBoolean("pathInfoOnly", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("  .baseResource = {}", (Object)baseResource);
            LOG.debug("  .resourceService = {}", (Object)this._resourceService);
            LOG.debug("  .welcomeServletMode = {}", (Object)this._welcomeServletMode);
        }
    }

    private ByteBufferPool.Sized getByteBufferPool(ContextHandler contextHandler) {
        if (this._bufferPool != null) {
            return this._bufferPool;
        }
        if (contextHandler == null) {
            return ByteBufferPool.SIZED_NON_POOLING;
        }
        Server server = contextHandler.getServer();
        if (server == null) {
            return ByteBufferPool.SIZED_NON_POOLING;
        }
        this._bufferPool = new ByteBufferPool.Sized(server.getByteBufferPool(), this.getInitBoolean("useDirectByteBuffers", true), this.getInitInt("byteBufferSize", 32768));
        return this._bufferPool;
    }

    private String getInitParameter(String name, String ... deprecated) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        for (String d : deprecated) {
            value = this.getInitParameter(d);
            if (value == null) continue;
            LOG.warn("Deprecated {} used instead of {}", (Object)d, (Object)name);
            return value;
        }
        return null;
    }

    private List<CompressedContentFormat> parsePrecompressedFormats(String precompressed, Boolean gzip, List<CompressedContentFormat> dft) {
        if (precompressed == null && gzip == null) {
            return dft;
        }
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String pair : precompressed.split(",")) {
                String[] setting = pair.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (gzip != Boolean.TRUE || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            if (Boolean.parseBoolean(precompressed)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (gzip == Boolean.TRUE) {
            ret.add(CompressedContentFormat.GZIP);
        }
        return ret;
    }

    private Boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private boolean getInitBoolean(String name, boolean dft) {
        return Optional.ofNullable(this.getInitBoolean(name)).orElse(dft);
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value != null && !value.isEmpty()) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    protected ServletContextHandler initContextHandler(ServletContext servletContext) {
        if (servletContext instanceof ServletContextHandler.ServletContextApi) {
            ServletContextHandler.ServletContextApi api = (ServletContextHandler.ServletContextApi)servletContext;
            return api.getContext().getServletContextHandler();
        }
        Context context = ContextHandler.getCurrentContext();
        if (context instanceof ContextHandler.ScopedContext) {
            ContextHandler.ScopedContext scopedContext = (ContextHandler.ScopedContext)context;
            return (ServletContextHandler)scopedContext.getContextHandler();
        }
        throw new IllegalArgumentException("The servletContext " + String.valueOf(servletContext) + " " + servletContext.getClass().getName() + " is not " + ContextHandler.ScopedContext.class.getName());
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block20: {
            boolean included = httpServletRequest.getDispatcherType() == DispatcherType.INCLUDE;
            String encodedPathInContext = this.getEncodedPathInContext(httpServletRequest, included);
            if (LOG.isDebugEnabled()) {
                LOG.debug("doGet(hsReq={}, hsResp={}) pathInContext={}, included={}", new Object[]{httpServletRequest, httpServletResponse, encodedPathInContext, included});
            }
            try {
                String characterEncoding;
                ServletCoreResponse coreResponse;
                Object content = this._resourceService.getContent(encodedPathInContext, (Request)ServletContextRequest.getServletContextRequest((ServletRequest)httpServletRequest));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("content = {}", content);
                }
                if (content == null || Resources.missing((Resource)content.getResource())) {
                    this.doNotFound(httpServletRequest, httpServletResponse, encodedPathInContext);
                    break block20;
                }
                ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)httpServletRequest);
                ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
                ServletChannel servletChannel = servletContextRequest.getServletChannel();
                Request coreRequest = httpServletRequest instanceof ServletApiRequest ? servletChannel.getRequest() : ServletCoreRequest.wrap(httpServletRequest);
                boolean useServletResponse = !(httpServletResponse instanceof ServletApiResponse) || servletContextResponse.isWritingOrStreaming();
                ServletCoreResponse servletCoreResponse = coreResponse = useServletResponse ? new ServletCoreResponse(coreRequest, httpServletResponse, included) : servletChannel.getResponse();
                if (coreResponse.isCommitted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Response already committed for {}", (Object)coreRequest.getHttpURI());
                    }
                    return;
                }
                long contentLength = content.getContentLengthValue();
                if (useServletResponse) {
                    content = new UnknownLengthHttpContent((HttpContent)content);
                }
                if ((characterEncoding = servletContextResponse.getRawCharacterEncoding()) != null) {
                    content = new ForcedCharacterEncodingHttpContent((HttpContent)content, characterEncoding);
                }
                if (httpServletRequest.isAsyncSupported() && (contentLength < 0L || contentLength > (long)coreRequest.getConnectionMetaData().getHttpConfiguration().getOutputBufferSize())) {
                    AsyncContext asyncContext = httpServletRequest.startAsync();
                    AsyncContextCallback callback = new AsyncContextCallback(asyncContext, httpServletResponse);
                    this._resourceService.doGet(coreRequest, coreResponse, callback, (HttpContent)content);
                    break block20;
                }
                try (Blocker.Callback callback = Blocker.callback();){
                    this._resourceService.doGet(coreRequest, coreResponse, (Callback)callback, (HttpContent)content);
                    callback.block();
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (InvalidPathException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("InvalidPathException for pathInContext: {}", (Object)encodedPathInContext, (Object)e);
                }
                if (included) {
                    throw new FileNotFoundException(encodedPathInContext);
                }
                httpServletResponse.setStatus(404);
            }
        }
    }

    protected String getEncodedPathInContext(HttpServletRequest request, boolean included) {
        HttpServletMapping mapping = request.getHttpServletMapping();
        if (included) {
            Object object = request.getAttribute("jakarta.servlet.include.mapping");
            if (object instanceof HttpServletMapping) {
                HttpServletMapping httpServletMapping;
                mapping = httpServletMapping = (HttpServletMapping)object;
            } else {
                return URIUtil.encodePath((String)URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo()));
            }
        }
        return switch (mapping.getMappingMatch()) {
            default -> throw new IncompatibleClassChangeError();
            case MappingMatch.CONTEXT_ROOT -> "/";
            case MappingMatch.DEFAULT, MappingMatch.EXTENSION, MappingMatch.EXACT -> {
                ServletApiRequest apiRequest;
                if (included) {
                    yield URIUtil.encodePath((String)((String)request.getAttribute("jakarta.servlet.include.servlet_path")));
                }
                if (request instanceof ServletApiRequest) {
                    apiRequest = (ServletApiRequest)request;
                    yield Context.getPathInContext((String)request.getContextPath(), (String)apiRequest.getRequest().getHttpURI().getCanonicalPath());
                }
                yield URIUtil.encodePath((String)request.getServletPath());
            }
            case MappingMatch.PATH -> {
                ServletApiRequest apiRequest;
                if (this._pathInfoOnly) {
                    if (included) {
                        yield URIUtil.encodePath((String)((String)request.getAttribute("jakarta.servlet.include.path_info")));
                    }
                    yield URIUtil.encodePath((String)request.getPathInfo());
                }
                if (included) {
                    yield URIUtil.encodePath((String)URIUtil.addPaths((String)((String)request.getAttribute("jakarta.servlet.include.servlet_path")), (String)((String)request.getAttribute("jakarta.servlet.include.path_info"))));
                }
                if (request instanceof ServletApiRequest) {
                    apiRequest = (ServletApiRequest)request;
                    yield Context.getPathInContext((String)request.getContextPath(), (String)apiRequest.getRequest().getHttpURI().getCanonicalPath());
                }
                yield URIUtil.encodePath((String)URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo()));
            }
        };
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doHead(req={}, resp={}) (calling doGet())", (Object)req, (Object)resp);
        }
        this.doGet(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET, HEAD, OPTIONS");
    }

    protected void doNotFound(HttpServletRequest request, HttpServletResponse response, String encodedPathInContext) throws IOException {
        if (request.getDispatcherType() == DispatcherType.INCLUDE) {
            throw new FileNotFoundException(encodedPathInContext);
        }
        response.sendError(404);
    }

    static String getIncludedPathInContext(HttpServletRequest request, String includedServletPath) {
        String pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
        return URIUtil.addPaths((String)includedServletPath, (String)pathInfo);
    }

    private static boolean isIncluded(HttpServletRequest request) {
        return request.getAttribute("jakarta.servlet.include.request_uri") != null;
    }

    private class ServletResourceService
    extends ResourceService
    implements ResourceService.WelcomeFactory {
        private final ServletContextHandler _servletContextHandler;

        private ServletResourceService(ServletContextHandler servletContextHandler) {
            this._servletContextHandler = servletContextHandler;
        }

        public String getWelcomeTarget(HttpContent content, Request coreRequest) {
            String[] welcomes = this._servletContextHandler.getWelcomeFiles();
            if (welcomes == null) {
                return null;
            }
            String pathInContext = Request.getPathInContext((Request)coreRequest);
            String welcomeTarget = null;
            Resource base = content.getResource();
            if (Resources.isReadableDirectory((Resource)base)) {
                for (String welcome : welcomes) {
                    ServletHandler.MappedServlet entry;
                    String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)welcome);
                    Resource welcomePath = content.getResource().resolve(welcome);
                    if (Resources.isReadableFile((Resource)welcomePath)) {
                        return welcomeInContext;
                    }
                    if (ResourceServlet.this._welcomeServletMode == WelcomeServletMode.NONE || welcomeTarget != null || (entry = this._servletContextHandler.getServletHandler().getMappedServlet(welcomeInContext)) == null || entry.getServletHolder().getServletInstance() == ResourceServlet.this || ResourceServlet.this._welcomeServletMode != WelcomeServletMode.MATCH && !entry.getPathSpec().getDeclaration().equals(welcomeInContext)) continue;
                    welcomeTarget = welcomeInContext;
                }
            }
            return welcomeTarget;
        }

        protected void serveWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            HttpServletRequest servletRequest = this.getServletRequest(request);
            HttpServletResponse servletResponse = this.getServletResponse(response);
            boolean included = ResourceServlet.isIncluded(servletRequest);
            RequestDispatcher dispatcher = servletRequest.getServletContext().getRequestDispatcher(welcomeTarget);
            if (dispatcher == null) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500);
                return;
            }
            try {
                if (included) {
                    dispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                } else {
                    servletRequest.setAttribute("org.eclipse.jetty.server.welcome", (Object)welcomeTarget);
                    dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                }
                callback.succeeded();
            }
            catch (ServletException e) {
                callback.failed((Throwable)e);
            }
        }

        protected void rehandleWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            this.serveWelcome(request, response, callback, welcomeTarget);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={})", new Object[]{coreRequest, coreResponse, callback, statusCode});
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, null, null);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, cause={})", new Object[]{coreRequest, coreResponse, callback, cause, cause});
            }
            int statusCode = 500;
            String reason = null;
            if (cause instanceof HttpException) {
                HttpException httpException = (HttpException)cause;
                statusCode = httpException.getCode();
                reason = httpException.getReason();
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, reason, cause);
        }

        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode, String reason, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={}, reason={}, cause={})", new Object[]{coreRequest, coreResponse, callback, statusCode, reason, cause, cause});
            }
            HttpServletRequest request = this.getServletRequest(coreRequest);
            HttpServletResponse response = this.getServletResponse(coreResponse);
            try {
                if (ResourceServlet.isIncluded(request)) {
                    return;
                }
                if (cause != null) {
                    request.setAttribute("jakarta.servlet.error.exception", (Object)cause);
                }
                response.sendError(statusCode, reason);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                callback.succeeded();
            }
        }

        protected boolean passConditionalHeaders(Request request, Response response, HttpContent content, Callback callback) throws IOException {
            boolean included = ResourceServlet.isIncluded(this.getServletRequest(request));
            if (included) {
                return false;
            }
            return super.passConditionalHeaders(request, response, content, callback);
        }

        private HttpServletRequest getServletRequest(Request request) {
            ServletCoreRequest servletCoreRequest = (ServletCoreRequest)Request.as((Request)request, ServletCoreRequest.class);
            if (servletCoreRequest != null) {
                return servletCoreRequest.getServletRequest();
            }
            ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
            if (servletContextRequest != null) {
                return servletContextRequest.getServletApiRequest();
            }
            throw new IllegalStateException("instanceof " + String.valueOf(request.getClass()));
        }

        private HttpServletResponse getServletResponse(Response response) {
            ServletCoreResponse servletCoreResponse = (ServletCoreResponse)Response.as((Response)response, ServletCoreResponse.class);
            if (servletCoreResponse != null) {
                return servletCoreResponse.getServletResponse();
            }
            ServletContextResponse servletContextResponse = (ServletContextResponse)Response.as((Response)response, ServletContextResponse.class);
            if (servletContextResponse != null) {
                return servletContextResponse.getServletApiResponse();
            }
            throw new IllegalStateException("instanceof " + String.valueOf(response.getClass()));
        }
    }

    private static enum WelcomeServletMode {
        NONE,
        MATCH,
        EXACT;

    }

    private static class UnknownLengthHttpContent
    extends HttpContent.Wrapper {
        public UnknownLengthHttpContent(HttpContent content) {
            super(content);
        }

        public HttpField getContentLength() {
            return null;
        }

        public long getContentLengthValue() {
            return -1L;
        }
    }

    private static class ForcedCharacterEncodingHttpContent
    extends HttpContent.Wrapper {
        private final String characterEncoding;
        private final HttpField contentType;

        public ForcedCharacterEncodingHttpContent(HttpContent content, String characterEncoding) {
            super(Objects.requireNonNull(content));
            this.characterEncoding = characterEncoding;
            if (content.getContentTypeValue() == null || content.getResource().isDirectory()) {
                this.contentType = null;
            } else {
                String mimeType = content.getContentTypeValue();
                int idx = mimeType.indexOf(";charset");
                if (idx >= 0) {
                    mimeType = mimeType.substring(0, idx);
                }
                this.contentType = new HttpField(HttpHeader.CONTENT_TYPE, mimeType + ";charset=" + characterEncoding);
            }
        }

        public HttpField getContentType() {
            return this.contentType;
        }

        public String getCharacterEncoding() {
            return this.characterEncoding;
        }
    }

    private static class AsyncContextCallback
    implements Callback {
        private final AsyncContext _asyncContext;
        private final HttpServletResponse _response;

        private AsyncContextCallback(AsyncContext asyncContext, HttpServletResponse response) {
            this._asyncContext = asyncContext;
            this._response = response;
        }

        public void succeeded() {
            this._asyncContext.complete();
        }

        public void failed(Throwable x) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AsyncContextCallback failed {}", (Object)this._asyncContext, (Object)x);
                }
                this._response.sendError(-1);
            }
            catch (IOException e) {
                ExceptionUtil.addSuppressedIfNotAssociated((Throwable)x, (Throwable)e);
            }
            finally {
                this._asyncContext.complete();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Async get failed", x);
            }
        }
    }
}

