/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.ee10.servlet.ContentProducer;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StaticException;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncContentProducer
implements ContentProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncContentProducer.class);
    private static final Content.Chunk RECYCLED_ERROR_CHUNK = Content.Chunk.from((Throwable)new StaticException("ContentProducer has been recycled"), (boolean)true);
    final AutoLock _lock;
    private final ServletChannel _servletChannel;
    private final DemandTask _demandTask;
    private Content.Chunk _chunk;
    private long _firstByteNanoTime = Long.MIN_VALUE;
    private long _bytesArrived;

    AsyncContentProducer(ServletChannel servletChannel, AutoLock lock) {
        this._servletChannel = servletChannel;
        this._lock = lock;
        this._demandTask = new DemandTask();
    }

    ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    @Override
    public void recycle() {
        this.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("recycling {}", (Object)this);
        }
        if (this._chunk != null) {
            this._chunk.release();
        }
        this._chunk = RECYCLED_ERROR_CHUNK;
    }

    @Override
    public void reopen() {
        this.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("reopening {}", (Object)this);
        }
        this._chunk = null;
        this._firstByteNanoTime = Long.MIN_VALUE;
        this._bytesArrived = 0L;
    }

    @Override
    public int available() {
        int available;
        this.assertLocked();
        Content.Chunk chunk = this.produceChunk();
        int n = available = chunk == null ? 0 : chunk.remaining();
        if (LOG.isDebugEnabled()) {
            LOG.debug("available = {} {}", (Object)available, (Object)this);
        }
        return available;
    }

    @Override
    public boolean hasChunk() {
        boolean hasChunk;
        this.assertLocked();
        boolean bl = hasChunk = this._chunk != null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("hasChunk = {} {}", (Object)hasChunk, (Object)this);
        }
        return hasChunk;
    }

    @Override
    public boolean isError() {
        this.assertLocked();
        boolean failure = Content.Chunk.isFailure((Content.Chunk)this._chunk, (boolean)true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("isFailure = {} {}", (Object)failure, (Object)this);
        }
        return failure;
    }

    @Override
    public void checkMinDataRate() {
        long period;
        this.assertLocked();
        long minRequestDataRate = this._servletChannel.getHttpConfiguration().getMinRequestDataRate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("checkMinDataRate [m={},t={}] {}", new Object[]{minRequestDataRate, this._firstByteNanoTime, this});
        }
        if (minRequestDataRate > 0L && this._firstByteNanoTime != Long.MIN_VALUE && (period = NanoTime.since((long)this._firstByteNanoTime)) > 0L) {
            long minimumData = minRequestDataRate * TimeUnit.NANOSECONDS.toMillis(period) / TimeUnit.SECONDS.toMillis(1L);
            if (this.getBytesArrived() < minimumData) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("checkMinDataRate check failed {}", (Object)this);
                }
                BadMessageException bad = new BadMessageException(408, String.format("Request content data rate < %d B/s", minRequestDataRate));
                if (this._servletChannel.getServletRequestState().isResponseCommitted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("checkMinDataRate aborting channel {}", (Object)this);
                    }
                    this._servletChannel.abort((Throwable)bad);
                }
                this.consumeCurrentChunk();
                throw bad;
            }
        }
    }

    @Override
    public long getBytesArrived() {
        this.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getBytesArrived = {} {}", (Object)this._bytesArrived, (Object)this);
        }
        return this._bytesArrived;
    }

    @Override
    public boolean consumeAvailable() {
        this.assertLocked();
        boolean atEof = this.consumeCurrentChunk();
        if (LOG.isDebugEnabled()) {
            LOG.debug("consumed current chunk of ServletChannel EOF={} {}", (Object)atEof, (Object)this);
        }
        if (atEof) {
            return true;
        }
        atEof = this.consumeAvailableChunks();
        if (LOG.isDebugEnabled()) {
            LOG.debug("consumed available chunks of ServletChannel EOF={} {}", (Object)atEof, (Object)this);
        }
        return atEof;
    }

    private boolean consumeCurrentChunk() {
        if (this._chunk != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("consuming and releasing current chunk {}", (Object)this);
            }
            this._chunk.skip((long)this._chunk.remaining());
            this._chunk.release();
            this._chunk = this._chunk.isLast() ? Content.Chunk.EOF : null;
        }
        return this._chunk != null && this._chunk.isLast();
    }

    private boolean consumeAvailableChunks() {
        return this._servletChannel.getRequest().consumeAvailable();
    }

    @Override
    public boolean onContentProducible() {
        this.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContentProducible {}", (Object)this);
        }
        return this._servletChannel.getServletRequestState().onReadReady();
    }

    @Override
    public Content.Chunk nextChunk() {
        this.assertLocked();
        Content.Chunk chunk = this.produceChunk();
        if (LOG.isDebugEnabled()) {
            LOG.debug("nextChunk = {} {}", (Object)chunk, (Object)this);
        }
        if (chunk != null) {
            this._servletChannel.getServletRequestState().onReadIdle();
            if (Content.Chunk.isFailure((Content.Chunk)chunk, (boolean)false)) {
                this._chunk = Content.Chunk.next((Content.Chunk)chunk);
            }
        }
        return chunk;
    }

    @Override
    public void reclaim(Content.Chunk chunk) {
        this.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("reclaim {} {}", (Object)chunk, (Object)this);
        }
        if (chunk != this._chunk) {
            throw new IllegalArgumentException("Cannot reclaim unknown chunk");
        }
        chunk.release();
        this._chunk = Content.Chunk.next((Content.Chunk)this._chunk);
    }

    @Override
    public boolean isReady() {
        this.assertLocked();
        ServletChannelState state = this._servletChannel.getServletRequestState();
        if (state.isInputUnready()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isReady(), unready {}", (Object)this);
            }
            return false;
        }
        Content.Chunk chunk = this.produceChunk();
        if (chunk != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isReady(), got chunk {} {}", (Object)chunk, (Object)this);
            }
            return true;
        }
        state.onReadUnready();
        this._servletChannel.getRequest().demand((Runnable)((Object)this._demandTask));
        if (LOG.isDebugEnabled()) {
            LOG.debug("isReady(), no chunk {}", (Object)this);
        }
        return false;
    }

    boolean isUnready() {
        return this._servletChannel.getServletRequestState().isInputUnready();
    }

    private Content.Chunk produceChunk() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("produceChunk() {}", (Object)this);
        }
        while (true) {
            if (this._chunk != null) {
                if (Content.Chunk.isFailure((Content.Chunk)this._chunk, (boolean)false)) {
                    return this._chunk;
                }
                if (this._chunk.isLast() || this._chunk.hasRemaining()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("chunk not yet depleted, returning it {}", (Object)this);
                    }
                    return this._chunk;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("current chunk depleted {}", (Object)this);
                }
                this._chunk.release();
                this._chunk = null;
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("reading new chunk {}", (Object)this);
            }
            this._chunk = this.readChunk();
            if (this._chunk == null) break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("channel has no new chunk {}", (Object)this);
        }
        return null;
    }

    private Content.Chunk readChunk() {
        if (this._servletChannel.getServletRequestState().isInputUnready()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("readChunk() in unready state, returning null {}", (Object)this);
            }
            return null;
        }
        Content.Chunk chunk = this._servletChannel.getRequest().read();
        if (chunk != null) {
            this._bytesArrived += (long)chunk.remaining();
            if (this._firstByteNanoTime == Long.MIN_VALUE) {
                this._firstByteNanoTime = NanoTime.now();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("readChunk() updated _bytesArrived to {} and _firstByteTimeStamp to {} {}", new Object[]{this._bytesArrived, this._firstByteNanoTime, this});
            }
            if (chunk instanceof Trailers) {
                Trailers trailers = (Trailers)chunk;
                this._servletChannel.onTrailers(trailers.getTrailers());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("readChunk() produced {} {}", (Object)chunk, (Object)this);
        }
        return chunk;
    }

    private void assertLocked() {
        if (!this._lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("ContentProducer must be called within lock scope");
        }
    }

    public String toString() {
        return String.format("%s@%x[c=%s]", this.getClass().getSimpleName(), this.hashCode(), this._chunk);
    }

    LockedSemaphore newLockedSemaphore() {
        return new LockedSemaphore();
    }

    private class DemandTask
    implements Invocable.Task {
        private DemandTask() {
        }

        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("isReady() demand callback {}", (Object)this);
            }
            if (AsyncContentProducer.this._servletChannel.getHttpInput().onContentProducible()) {
                AsyncContentProducer.this._servletChannel.handle();
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return AsyncContentProducer.this._servletChannel.getHttpInput().getInvocationType();
        }
    }

    class LockedSemaphore {
        private final Condition _condition;
        private int _permits;

        private LockedSemaphore() {
            this._condition = AsyncContentProducer.this._lock.newCondition();
        }

        void assertLocked() {
            if (!AsyncContentProducer.this._lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("LockedSemaphore must be called within lock scope");
            }
        }

        void drainPermits() {
            this._permits = 0;
        }

        void acquire() throws InterruptedException {
            while (this._permits == 0) {
                this._condition.await();
            }
            --this._permits;
        }

        void release() {
            ++this._permits;
            this._condition.signal();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " permits=" + this._permits;
        }
    }
}

