/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.UriPatternPredicate;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollators;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.ResourceUriPatternPredicate;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetaInfConfiguration.class);
    public static final String USE_CONTAINER_METAINF_CACHE = "org.eclipse.jetty.metainf.useCache";
    public static final boolean DEFAULT_USE_CONTAINER_METAINF_CACHE = true;
    public static final String CACHED_CONTAINER_TLDS = "org.eclipse.jetty.tlds.cache";
    public static final String CACHED_CONTAINER_FRAGMENTS = FragmentConfiguration.FRAGMENT_RESOURCES + ".cache";
    public static final String CACHED_CONTAINER_RESOURCES = "org.eclipse.jetty.resources.cache";
    public static final String METAINF_TLDS = "org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = FragmentConfiguration.FRAGMENT_RESOURCES;
    public static final String METAINF_RESOURCES = "org.eclipse.jetty.resources";
    public static final String CONTAINER_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    public static final String WEBINF_JAR_PATTERN = "org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern";
    public static final List<String> __allScanTypes = Arrays.asList("org.eclipse.jetty.tlds", "org.eclipse.jetty.resources", METAINF_FRAGMENTS);
    public static final String RESOURCE_DIRS = "org.eclipse.jetty.resources";

    public MetaInfConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebXmlConfiguration.class));
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.findAndFilterContainerPaths(context);
        this.findAndFilterWebAppPaths(context);
        context.getMetaData().setWebInfClassesResources(this.findClassDirs(context));
        this.scanJars(context);
    }

    public void findAndFilterContainerPaths(WebAppContext context) throws Exception {
        String modulePath;
        String pattern = (String)context.getAttribute(CONTAINER_JAR_PATTERN);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}={}", (Object)CONTAINER_JAR_PATTERN, (Object)pattern);
        }
        if (StringUtil.isBlank((String)pattern)) {
            return;
        }
        ResourceFactory resourceFactory = ResourceFactory.of((Container)context);
        UriPatternPredicate uriPatternPredicate = new UriPatternPredicate(pattern, false);
        Consumer<URI> addContainerResource = uri -> {
            Resource resource = resourceFactory.newResource(uri);
            if (Resources.missing((Resource)resource)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Classpath URI doesn't exist: " + String.valueOf(uri));
                }
            } else {
                context.getMetaData().addContainerResource(resource);
            }
        };
        List<URI> containerUris = this.getAllContainerJars(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All container urls {}", containerUris);
        }
        containerUris.stream().filter(uriPatternPredicate).forEach(addContainerResource);
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            Stream.of(classPath.split(File.pathSeparator)).map(URIUtil::toURI).filter((Predicate<URI>)uriPatternPredicate).forEach(addContainerResource);
        }
        if ((modulePath = System.getProperty("jdk.module.path")) != null) {
            List<Path> matchingBasePaths = Stream.of(modulePath.split(File.pathSeparator)).map(URIUtil::toURI).filter((Predicate<URI>)uriPatternPredicate).map(Paths::get).toList();
            for (Path path : matchingBasePaths) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Stream<Path> listing = Files.list(path);
                    try {
                        for (Path listEntry : listing.toList()) {
                            Resource resource = resourceFactory.newResource(listEntry);
                            context.getMetaData().addContainerResource(resource);
                        }
                        continue;
                    }
                    finally {
                        if (listing != null) {
                            listing.close();
                        }
                        continue;
                    }
                }
                Resource resource = resourceFactory.newResource(path);
                context.getMetaData().addContainerResource(resource);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container paths selected:{}", context.getMetaData().getContainerResources());
        }
    }

    public void findAndFilterWebAppPaths(WebAppContext context) throws Exception {
        String pattern = (String)context.getAttribute(WEBINF_JAR_PATTERN);
        ResourceUriPatternPredicate webinfPredicate = new ResourceUriPatternPredicate(pattern, true);
        List<Resource> jars = this.findJars(context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("webapp {}={} jars {}", new Object[]{WEBINF_JAR_PATTERN, pattern, jars});
        }
        if (jars != null) {
            jars.stream().filter(webinfPredicate).forEach(resource -> context.getMetaData().addWebInfResource((Resource)resource));
        }
    }

    protected List<URI> getAllContainerJars(WebAppContext context) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (ClassLoader loader = MetaInfConfiguration.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URLClassLoader urlCL = (URLClassLoader)loader;
            URIUtil.streamOf((URLClassLoader)urlCL).forEach(uris::add);
        }
        return uris;
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        Set resources = (Set)context.getAttribute("org.eclipse.jetty.resources");
        if (resources != null && !resources.isEmpty()) {
            ArrayList<Resource> collection = new ArrayList<Resource>();
            collection.add(context.getBaseResource());
            collection.addAll(resources);
            context.setBaseResource(ResourceFactory.combine(collection));
        }
    }

    protected void scanJars(WebAppContext context) throws Exception {
        Boolean attr;
        boolean useContainerCache = true;
        if (context.getServer() != null && (attr = (Boolean)context.getServer().getAttribute(USE_CONTAINER_METAINF_CACHE)) != null) {
            useContainerCache = attr;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} = {}", (Object)USE_CONTAINER_METAINF_CACHE, (Object)useContainerCache);
        }
        if (context.getAttribute(METAINF_TLDS) == null) {
            context.setAttribute(METAINF_TLDS, new HashSet());
        }
        if (context.getAttribute("org.eclipse.jetty.resources") == null) {
            context.setAttribute("org.eclipse.jetty.resources", new HashSet());
        }
        if (context.getAttribute(METAINF_FRAGMENTS) == null) {
            context.setAttribute(METAINF_FRAGMENTS, new HashMap());
        }
        this.scanJars(context, context.getMetaData().getContainerResources(), useContainerCache, __allScanTypes);
        ArrayList<String> scanTypes = new ArrayList<String>(__allScanTypes);
        if (context.getMetaData().isMetaDataComplete() || context.getServletContext().getEffectiveMajorVersion() < 3 && !context.isConfigurationDiscovered()) {
            scanTypes.remove(METAINF_FRAGMENTS);
        }
        this.scanJars(context, context.getMetaData().getWebInfResources(false), false, scanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches) throws Exception {
        this.scanJars(context, jars, useCaches, __allScanTypes);
    }

    public void scanJars(WebAppContext context, Collection<Resource> jars, boolean useCaches, List<String> scanTypes) throws Exception {
        ConcurrentHashMap<Resource, Resource> metaInfResourceCache = null;
        ConcurrentHashMap<Resource, Resource> metaInfFragmentCache = null;
        ConcurrentHashMap<Resource, Collection<URL>> metaInfTldCache = null;
        if (useCaches) {
            metaInfResourceCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_RESOURCES);
            if (metaInfResourceCache == null) {
                metaInfResourceCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_RESOURCES, metaInfResourceCache);
            }
            if ((metaInfFragmentCache = (ConcurrentHashMap<Resource, Resource>)context.getServer().getAttribute(CACHED_CONTAINER_FRAGMENTS)) == null) {
                metaInfFragmentCache = new ConcurrentHashMap<Resource, Resource>();
                context.getServer().setAttribute(CACHED_CONTAINER_FRAGMENTS, metaInfFragmentCache);
            }
            if ((metaInfTldCache = (ConcurrentHashMap<Resource, Collection<URL>>)context.getServer().getAttribute(CACHED_CONTAINER_TLDS)) == null) {
                metaInfTldCache = new ConcurrentHashMap<Resource, Collection<URL>>();
                context.getServer().setAttribute(CACHED_CONTAINER_TLDS, metaInfTldCache);
            }
        }
        if (jars != null) {
            for (Resource r : jars) {
                if (scanTypes.contains("org.eclipse.jetty.resources")) {
                    this.scanForResources(context, r, metaInfResourceCache);
                }
                if (scanTypes.contains(METAINF_FRAGMENTS)) {
                    this.scanForFragment(context, r, metaInfFragmentCache);
                }
                if (!scanTypes.contains(METAINF_TLDS)) continue;
                this.scanForTlds(context, r, metaInfTldCache);
            }
        }
    }

    public void scanForResources(WebAppContext context, Resource target, ConcurrentHashMap<Resource, Resource> cache) {
        HashSet<Resource> dirs;
        Resource resourcesDir;
        if (Resources.missing((Resource)target)) {
            return;
        }
        ResourceFactory resourceFactory = ResourceFactory.of((Container)context);
        if (cache != null && cache.containsKey(target)) {
            resourcesDir = cache.get(target);
            if (MetaInfConfiguration.isEmptyResource(resourcesDir)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no META-INF/resources", (Object)target);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/resources found in cache ", (Object)target);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/resources checked", (Object)target);
            }
            if (target.isDirectory()) {
                resourcesDir = target.resolve("/META-INF/resources");
            } else {
                URI uri = target.getURI();
                resourcesDir = resourceFactory.newResource(URIUtil.uriJarPrefix((URI)uri, (String)"!/META-INF/resources"));
            }
            if (Resources.isReadableDirectory((Resource)resourcesDir) && cache != null) {
                Resource old = cache.putIfAbsent(target, resourcesDir);
                if (old != null) {
                    resourcesDir = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("{} META-INF/resources cache updated", (Object)target);
                }
            }
            if (MetaInfConfiguration.isEmptyResource(resourcesDir)) {
                return;
            }
        }
        if ((dirs = (HashSet<Resource>)context.getAttribute("org.eclipse.jetty.resources")) == null) {
            dirs = new HashSet<Resource>();
            context.setAttribute("org.eclipse.jetty.resources", dirs);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added to context", (Object)resourcesDir);
        }
        dirs.add(resourcesDir);
    }

    private static boolean isEmptyResource(Resource resourcesDir) {
        return !Resources.isReadableDirectory((Resource)resourcesDir);
    }

    public void scanForFragment(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Resource> cache) {
        HashMap<Resource, Resource> fragments;
        Resource webFrag;
        ResourceFactory resourceFactory = ResourceFactory.of((Container)context);
        if (cache != null && cache.containsKey(jar)) {
            webFrag = cache.get(jar);
            if (MetaInfConfiguration.isEmptyFragment(webFrag)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no META-INF/web-fragment.xml", (Object)jar);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/web-fragment.xml found in cache ", (Object)jar);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} META-INF/web-fragment.xml checked", (Object)jar);
            }
            if (jar.isDirectory()) {
                webFrag = resourceFactory.newResource(jar.getPath().resolve("META-INF/web-fragment.xml"));
            } else {
                URI uri = jar.getURI();
                webFrag = resourceFactory.newResource(URIUtil.uriJarPrefix((URI)uri, (String)"!/META-INF/web-fragment.xml"));
            }
            if (Resources.isReadable((Resource)webFrag) && cache != null) {
                Resource old = cache.putIfAbsent(jar, webFrag);
                if (old != null) {
                    webFrag = old;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("{} META-INF/web-fragment.xml cache updated", (Object)jar);
                }
            }
            if (MetaInfConfiguration.isEmptyFragment(webFrag)) {
                return;
            }
        }
        if ((fragments = (HashMap<Resource, Resource>)context.getAttribute(METAINF_FRAGMENTS)) == null) {
            fragments = new HashMap<Resource, Resource>();
            context.setAttribute(METAINF_FRAGMENTS, fragments);
        }
        fragments.put(jar, webFrag);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added to context", (Object)webFrag);
        }
    }

    private static boolean isEmptyFragment(Resource webFrag) {
        return !Resources.isReadableFile((Resource)webFrag);
    }

    public void scanForTlds(WebAppContext context, Resource jar, ConcurrentHashMap<Resource, Collection<URL>> cache) throws Exception {
        Collection<Object> tlds;
        if (cache != null && cache.containsKey(jar)) {
            Collection<URL> tmp = cache.get(jar);
            if (tmp.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} cached as containing no tlds", (Object)jar);
                }
                return;
            }
            tlds = tmp;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} tlds found in cache ", (Object)jar);
            }
        } else {
            tlds = new HashSet<URL>();
            if (jar.isDirectory()) {
                tlds.addAll(this.getTlds(jar.getPath()));
            } else {
                URI uri = jar.getURI();
                tlds.addAll(this.getTlds(context, uri));
            }
            if (cache != null) {
                Collection<Object> old;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} tld cache updated", (Object)jar);
                }
                if ((old = cache.putIfAbsent(jar, tlds)) != null) {
                    tlds = old;
                }
            }
            if (tlds.isEmpty()) {
                return;
            }
        }
        HashSet<Object> metaInfTlds = (HashSet<Object>)context.getAttribute(METAINF_TLDS);
        if (metaInfTlds == null) {
            metaInfTlds = new HashSet<Object>();
            context.setAttribute(METAINF_TLDS, metaInfTlds);
        }
        metaInfTlds.addAll(tlds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("tlds added to context");
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute("org.eclipse.jetty.resources", null);
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_TLDS, null);
    }

    private Collection<URL> getTlds(Path dir) throws IOException {
        if (dir == null || !Files.isDirectory(dir, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<URL> tlds = new HashSet<URL>();
        try (Stream<Path> entries = Files.walk(dir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(FileID::isTld);){
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Path entry = (Path)iter.next();
                tlds.add(entry.toUri().toURL());
            }
        }
        return tlds;
    }

    private Collection<URL> getTlds(WebAppContext context, URI uri) throws IOException {
        HashSet<URL> tlds = new HashSet<URL>();
        Resource r = ResourceFactory.of((Container)context).newResource(URIUtil.uriJarPrefix((URI)uri, (String)"!/"));
        try (Stream<Path> stream = Files.walk(r.getPath(), new FileVisitOption[0]);){
            Iterator it = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(FileID::isTld).iterator();
            while (it.hasNext()) {
                Path entry = (Path)it.next();
                tlds.add(entry.toUri().toURL());
            }
        }
        return tlds;
    }

    protected List<Resource> findClassDirs(WebAppContext context) throws Exception {
        if (context == null) {
            return null;
        }
        ArrayList<Resource> classDirs = new ArrayList<Resource>();
        Resource webInfClasses = this.findWebInfClassesDir(context);
        if (webInfClasses != null) {
            classDirs.add(webInfClasses);
        }
        classDirs.addAll(this.findExtraClasspathDirs(context));
        return classDirs;
    }

    protected List<Resource> findJars(WebAppContext context) throws Exception {
        ArrayList<Resource> jarResources = new ArrayList<Resource>(this.findWebInfLibJars(context));
        List<Resource> extraClasspathJars = this.findExtraClasspathJars(context);
        if (extraClasspathJars != null) {
            jarResources.addAll(extraClasspathJars);
        }
        return jarResources;
    }

    protected List<Resource> findWebInfLibJars(WebAppContext context) throws Exception {
        if (context == null) {
            return List.of();
        }
        Resource webInf = context.getWebInf();
        if (webInf == null || !webInf.exists() || !webInf.isDirectory()) {
            return List.of();
        }
        Resource webInfLib = webInf.resolve("lib");
        if (Resources.isReadableDirectory((Resource)webInfLib)) {
            return webInfLib.list().stream().filter(lib -> FileID.isLibArchive((String)lib.getFileName())).sorted(ResourceCollators.byName((boolean)true)).collect(Collectors.toList());
        }
        return List.of();
    }

    protected List<Resource> findExtraClasspathJars(WebAppContext context) {
        if (context == null || context.getExtraClasspath() == null) {
            return null;
        }
        return context.getExtraClasspath().stream().filter(this::isFileSupported).collect(Collectors.toList());
    }

    protected Resource findWebInfClassesDir(WebAppContext context) throws Exception {
        Resource webInfClassesDir;
        if (context == null) {
            return null;
        }
        Resource webInf = context.getWebInf();
        if (Resources.isReadableDirectory((Resource)webInf) && Resources.isReadableDirectory((Resource)(webInfClassesDir = webInf.resolve("classes/")))) {
            return webInfClassesDir;
        }
        return null;
    }

    protected List<Resource> findExtraClasspathDirs(WebAppContext context) {
        if (context == null || context.getExtraClasspath() == null) {
            return List.of();
        }
        return context.getExtraClasspath().stream().filter(Resource::isDirectory).collect(Collectors.toList());
    }

    private boolean isFileSupported(Resource resource) {
        return FileID.isLibArchive((URI)resource.getURI());
    }
}

