/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import org.eclipse.jetty.ee8.maven.plugin.OverlayConfig;
import org.eclipse.jetty.util.resource.Resource;

public class Overlay {
    private OverlayConfig _config;
    private Resource _resource;

    public Overlay(OverlayConfig config, Resource resource) {
        this._config = config;
        this._resource = resource;
    }

    public Overlay(OverlayConfig config) {
        this._config = config;
    }

    public void setResource(Resource r) {
        this._resource = r;
    }

    public Resource getResource() {
        return this._resource;
    }

    public OverlayConfig getConfig() {
        return this._config;
    }

    public String toString() {
        StringBuilder strbuff = new StringBuilder();
        if (this._resource != null) {
            strbuff.append(this._resource);
        }
        if (this._config != null) {
            strbuff.append(" [");
            strbuff.append(this._config);
            strbuff.append("]");
        }
        return strbuff.toString();
    }

    public void unpackTo(File dir) throws IOException {
        if (dir == null) {
            throw new IllegalStateException("No overly unpack directory");
        }
        Path pathDir = dir.toPath();
        if (!Files.exists(pathDir, new LinkOption[0])) {
            this.getResource().copyTo(pathDir);
        } else {
            Instant dirLastModified = Files.getLastModifiedTime(pathDir, new LinkOption[0]).toInstant();
            if (this.getResource().lastModified().isAfter(dirLastModified)) {
                this.getResource().copyTo(pathDir);
            }
        }
    }
}

