/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.ee8.security.IdentityService;
import org.eclipse.jetty.ee8.security.UserStore;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUserStore
extends UserStore
implements PathWatcher.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUserStore.class);
    protected Resource _configResource;
    protected PathWatcher _pathWatcher;
    protected boolean _hotReload = false;
    protected boolean _firstLoad = true;
    protected List<UserListener> _listeners;

    public Resource getConfig() {
        return this._configResource;
    }

    public void setConfig(Resource config) {
        this._configResource = config;
    }

    private Path extractPackedFile(Resource configResource) throws IOException {
        String uri = configResource.getURI().toASCIIString();
        int colon = uri.lastIndexOf(":");
        int bangSlash = uri.indexOf("!/");
        if (colon < 0 || bangSlash < 0 || colon > bangSlash) {
            throw new IllegalArgumentException("Not resolved JarFile resource: " + uri);
        }
        String entryPath = StringUtil.sanitizeFileSystemName((String)uri.substring(colon + 2));
        Path tmpDirectory = Files.createTempDirectory("users_store", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        Path extractedPath = Paths.get(tmpDirectory.toString(), entryPath);
        Files.deleteIfExists(extractedPath);
        extractedPath.toFile().deleteOnExit();
        try (InputStream is = Files.newInputStream(configResource.getPath(), new OpenOption[0]);
             OutputStream os = Files.newOutputStream(extractedPath, new OpenOption[0]);){
            IO.copy((InputStream)is, (OutputStream)os);
        }
        if (this.isHotReload()) {
            LOG.warn("Cannot hot reload from packed configuration: {}", (Object)configResource);
            this.setHotReload(false);
        }
        return extractedPath;
    }

    @Deprecated(forRemoval=true)
    public Resource getConfigResource() {
        return this.getConfig();
    }

    public boolean isHotReload() {
        return this._hotReload;
    }

    public void setHotReload(boolean enable) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this._hotReload = enable;
    }

    @Override
    public String toString() {
        return String.format("%s[cfg=%s]", super.toString(), this._configResource);
    }

    protected void loadUsers() throws IOException {
        Resource config = this.getConfig();
        if (config == null) {
            throw new IllegalStateException("No config path set");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading {} from {}", (Object)this, (Object)config);
        }
        if (!config.exists()) {
            throw new IllegalStateException("Config does not exist: " + config);
        }
        Properties properties = new Properties();
        try (InputStream inputStream = config.newInputStream();){
            properties.load(inputStream);
        }
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String username = ((String)entry.getKey()).trim();
            String credentials = ((String)entry.getValue()).trim();
            String roles = null;
            int c = credentials.indexOf(44);
            if (c >= 0) {
                roles = credentials.substring(c + 1).trim();
                credentials = credentials.substring(0, c).trim();
            }
            if (username.length() <= 0) continue;
            String[] roleArray = IdentityService.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = StringUtil.csvSplit((String)roles);
            }
            known.add(username);
            Credential credential = Credential.getCredential((String)credentials);
            this.addUser(username, credential, roleArray);
            this.notifyUpdate(username, credential, roleArray);
        }
        ArrayList currentlyKnownUsers = new ArrayList(this._users.keySet());
        if (!this._firstLoad) {
            for (String user : currentlyKnownUsers) {
                if (known.contains(user)) continue;
                this.removeUser(user);
                this.notifyRemove(user);
            }
        }
        this._firstLoad = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded {} from {}", (Object)this, (Object)config);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.loadUsers();
        Resource config = this.getConfig();
        if (this.isHotReload() && config != null) {
            this._pathWatcher = new PathWatcher();
            this._pathWatcher.watch(config.getPath());
            this._pathWatcher.addListener((EventListener)((Object)this));
            this._pathWatcher.setNotifyExistingOnStart(false);
            this._pathWatcher.start();
        }
    }

    public void onPathWatchEvent(PathWatcher.PathWatchEvent event) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path watch event: {}", (Object)event.getType());
            }
            this.loadUsers();
        }
        catch (IOException e) {
            LOG.warn("Unable to load users", (Throwable)e);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._pathWatcher != null) {
            this._pathWatcher.stop();
        }
        this._pathWatcher = null;
    }

    private void notifyUpdate(String username, Credential credential, String[] roleArray) {
        if (this._listeners != null) {
            for (UserListener listener : this._listeners) {
                listener.update(username, credential, roleArray);
            }
        }
    }

    private void notifyRemove(String username) {
        if (this._listeners != null) {
            for (UserListener listener : this._listeners) {
                listener.remove(username);
            }
        }
    }

    public void registerUserListener(UserListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<UserListener>();
        }
        this._listeners.add(listener);
    }

    public static interface UserListener {
        public void update(String var1, Credential var2, String[] var3);

        public void remove(String var1);
    }
}

