/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.ee8.nested.Request;
import org.eclipse.jetty.ee8.nested.Response;
import org.eclipse.jetty.ee8.nested.UserIdentity;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.ee8.security.IdentityService;
import org.eclipse.jetty.ee8.security.LoginService;
import org.eclipse.jetty.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        UserIdentity user = this._loginService.login(username, password, servletRequest);
        if (user != null) {
            Request request = Request.getBaseRequest((ServletRequest)servletRequest);
            if (request != null) {
                this.renewSession((HttpServletRequest)request, (HttpServletResponse)request.getResponse());
            }
            return user;
        }
        return null;
    }

    public void logout(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.sessionCreatedSecure");
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session.APISession) {
                        Session.APISession apiSession = (Session.APISession)httpSession;
                        Session session = apiSession.getCoreSession();
                        String oldId = session.getId();
                        session.renewId(Request.getBaseRequest((ServletRequest)request).getHttpChannel().getCoreRequest());
                        session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
                        if (session.isSetCookieNeeded() && response instanceof Response) {
                            ((Response)response).replaceCookie(session.getSessionManager().getSessionCookie(session, request.getContextPath(), request.isSecure()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("renew {}->{}", (Object)oldId, (Object)session.getId());
                        }
                    } else {
                        LOG.warn("Unable to renew session {}", (Object)httpSession);
                    }
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

