/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.ee8.nested.HttpChannel;
import org.eclipse.jetty.ee8.nested.SessionHandler;
import org.eclipse.jetty.ee8.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        org.eclipse.jetty.ee8.nested.Request baseRequest = org.eclipse.jetty.ee8.nested.Request.getBaseRequest((ServletRequest)servletRequest);
        if (baseRequest == null) {
            return null;
        }
        UserIdentity user = this._loginService.login(username, password, (Request)baseRequest.getCoreRequest(), SessionHandler.ServletSessionApi.getOrCreateSession((ServletRequest)servletRequest));
        if (user != null) {
            org.eclipse.jetty.ee8.nested.Request request = org.eclipse.jetty.ee8.nested.Request.getBaseRequest((ServletRequest)servletRequest);
            if (request != null) {
                this.renewSession((HttpServletRequest)request, (HttpServletResponse)request.getResponse());
            }
            return user;
        }
        return null;
    }

    public void logout(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.sessionCreatedSecure");
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session.API) {
                        Session.API api = (Session.API)httpSession;
                        org.eclipse.jetty.ee8.nested.Request baseRequest = org.eclipse.jetty.ee8.nested.Request.getBaseRequest((ServletRequest)request);
                        if (baseRequest != null) {
                            httpSession.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
                            HttpChannel httpChannel = baseRequest.getHttpChannel();
                            api.getSession().renewId((Request)httpChannel.getCoreRequest(), httpChannel.getCoreResponse());
                            return httpSession;
                        }
                    }
                    LOG.warn("Unable to renew session {}", (Object)httpSession);
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

