/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.servlet.listener;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.util.Loader;

public class ELContextCleaner
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            Class beanELResolver = Loader.loadClass((String)"javax.el.BeanELResolver");
            Field field = this.getField(beanELResolver);
            field.setAccessible(true);
            this.purgeEntries(sce.getServletContext(), field);
        }
        catch (ClassNotFoundException beanELResolver) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            sce.getServletContext().log("Cannot purge classes from javax.el.BeanELResolver", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            sce.getServletContext().log("Not cleaning cached beans: no such field javax.el.BeanELResolver.properties");
        }
    }

    protected Field getField(Class<?> beanELResolver) throws SecurityException, NoSuchFieldException {
        if (beanELResolver == null) {
            return null;
        }
        return beanELResolver.getDeclaredField("properties");
    }

    protected void purgeEntries(ServletContext context, Field properties) throws IllegalArgumentException, IllegalAccessException {
        if (properties == null) {
            return;
        }
        Map map = (Map)properties.get(null);
        if (map == null) {
            return;
        }
        Iterator itor = map.keySet().iterator();
        while (itor.hasNext()) {
            Class clazz = (Class)itor.next();
            context.log(String.format("Clazz: %s loaded by %s", clazz, clazz.getClassLoader()));
            if (Thread.currentThread().getContextClassLoader().equals(clazz.getClassLoader())) {
                itor.remove();
                context.log("removed");
                continue;
            }
            context.log(String.format("not removed: contextClassLoader=%s class's classLoader=%s", Thread.currentThread().getContextClassLoader(), clazz.getClassLoader()));
        }
    }
}

