/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.annotations;

import jakarta.annotation.Resource;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import jakarta.servlet.http.HttpUpgradeHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee9.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.webapp.MetaData;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAnnotationHandler.class);
    protected static final List<Class<?>> ENV_ENTRY_TYPES = Arrays.asList(String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class);

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (this.supportsResourceInjection(clazz)) {
            this.handleClass(clazz);
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.handleMethod(clazz, methods[i]);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.handleField(clazz, fields[i]);
            }
        }
    }

    public void handleClass(Class<?> clazz) {
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName) && !NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                LOG.warn("Unable to bind name {} to {} from class {}", new Object[]{name, mappedName, clazz, e});
            }
        }
    }

    public void handleField(Class<?> clazz, Field field) {
        block17: {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be static", (Object)clazz.getName(), (Object)field.getName());
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be final", (Object)clazz.getName(), (Object)field.getName());
                    return;
                }
                String name = clazz.getName() + "/" + field.getName();
                name = resource.name() != null && !resource.name().trim().isEmpty() ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().isEmpty() ? resource.mappedName() : null;
                Class<?> type = field.getType();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injections);
                }
                if ((injection = injections.getInjection(name, clazz, field)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)ContextHandler.ENVIRONMENT.getName(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                Object nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + (String)nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound {} as {}", mappedName == null ? name : mappedName, (Object)name);
                            injection = new Injection(clazz, field, type, name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection", (Annotation)resource, clazz);
                        } else if (!this.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (String)(mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(type)) break block17;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public void handleMethod(Class<?> clazz, Method method) {
        block19: {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(method.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be static", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (!method.getName().startsWith("set")) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, does not start with 'set'", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (method.getParameterCount() != 1) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, not single argument to method", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (Void.TYPE != method.getReturnType()) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, not void", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                Object name = method.getName().substring(3);
                name = ((String)name).substring(0, 1).toLowerCase(Locale.ENGLISH) + ((String)name).substring(1);
                name = clazz.getName() + "/" + (String)name;
                name = resource.name() != null && !resource.name().trim().isEmpty() ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().isEmpty() ? resource.mappedName() : null;
                Class<?> paramType = method.getParameterTypes()[0];
                Class resourceType = resource.type();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + (String)name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", (Object)injections);
                }
                if ((injection = injections.getInjection((String)name, clazz, method, paramType)) == null) {
                    try {
                        boolean bound = NamingEntryUtil.bindToENC((Object)this._context, (String)name, (String)mappedName);
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)ContextHandler.ENVIRONMENT.getName(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC((Object)this._context.getServer(), (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            bound = NamingEntryUtil.bindToENC(null, (String)name, (String)mappedName);
                        }
                        if (!bound) {
                            try {
                                InitialContext ic = new InitialContext();
                                Object nameInEnvironment = mappedName != null ? mappedName : name;
                                ic.lookup("java:comp/env/" + (String)nameInEnvironment);
                                bound = true;
                            }
                            catch (NameNotFoundException e) {
                                bound = false;
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound {} as {}", mappedName == null ? name : mappedName, name);
                            injection = new Injection(clazz, method, paramType, resourceType, (String)name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + (String)name + ".injection", (Annotation)resource, clazz);
                        } else if (!this.isEnvEntryType(paramType)) {
                            throw new IllegalStateException("No resource at " + (String)(mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(paramType)) break block19;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public boolean supportsResourceInjection(Class<?> c) {
        return Servlet.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || ServletContextListener.class.isAssignableFrom(c) || ServletContextAttributeListener.class.isAssignableFrom(c) || ServletRequestListener.class.isAssignableFrom(c) || ServletRequestAttributeListener.class.isAssignableFrom(c) || HttpSessionListener.class.isAssignableFrom(c) || HttpSessionAttributeListener.class.isAssignableFrom(c) || HttpSessionIdListener.class.isAssignableFrom(c) || AsyncListener.class.isAssignableFrom(c) || HttpUpgradeHandler.class.isAssignableFrom(c);
    }

    public boolean isEnvEntryType(Class<?> clazz) {
        return ENV_ENTRY_TYPES.contains(clazz);
    }
}

