/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.maven.plugin;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;

public class MavenServerConnector
extends ContainerLifeCycle
implements Connector {
    public static String PORT_SYSPROPERTY = "jetty.http.port";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PORT_STR = String.valueOf(8080);
    public static final int DEFAULT_MAX_IDLE_TIME = 30000;
    private Server server;
    private volatile ServerConnector delegate;
    private String host;
    private String name;
    private int port;
    private long idleTimeout;
    private boolean reusePort;

    public void setServer(Server server) {
        this.server = server;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected void doStart() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server not set for MavenServerConnector");
        }
        this.delegate = new ServerConnector(this.server);
        this.delegate.setName(this.name);
        this.delegate.setPort(this.port);
        this.delegate.setHost(this.host);
        this.delegate.setIdleTimeout(this.idleTimeout);
        this.delegate.setReusePort(this.reusePort);
        this.delegate.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.delegate.stop();
        super.doStop();
        this.delegate = null;
    }

    public CompletableFuture<Void> shutdown() {
        return this.checkDelegate().shutdown();
    }

    public boolean isShutdown() {
        return this.checkDelegate().isShutdown();
    }

    public Server getServer() {
        return this.server;
    }

    public Executor getExecutor() {
        return this.checkDelegate().getExecutor();
    }

    public Scheduler getScheduler() {
        return this.checkDelegate().getScheduler();
    }

    public ByteBufferPool getByteBufferPool() {
        return this.checkDelegate().getByteBufferPool();
    }

    public ConnectionFactory getConnectionFactory(String nextProtocol) {
        return this.checkDelegate().getConnectionFactory(nextProtocol);
    }

    public <T> T getConnectionFactory(Class<T> factoryType) {
        return (T)this.checkDelegate().getConnectionFactory(factoryType);
    }

    public ConnectionFactory getDefaultConnectionFactory() {
        return this.checkDelegate().getDefaultConnectionFactory();
    }

    public Collection<ConnectionFactory> getConnectionFactories() {
        return this.checkDelegate().getConnectionFactories();
    }

    public List<String> getProtocols() {
        return this.checkDelegate().getProtocols();
    }

    @ManagedAttribute(value="maximum time a connection can be idle before being closed (in ms)")
    public long getIdleTimeout() {
        return this.checkDelegate().getIdleTimeout();
    }

    public Object getTransport() {
        return this.checkDelegate().getTransport();
    }

    public Collection<EndPoint> getConnectedEndPoints() {
        return this.checkDelegate().getConnectedEndPoints();
    }

    public String getName() {
        return this.name;
    }

    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    private ServerConnector checkDelegate() throws IllegalStateException {
        ServerConnector d = this.delegate;
        if (d == null) {
            throw new IllegalStateException("MavenServerConnector delegate not ready");
        }
        return d;
    }
}

