/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.maven.plugin;

import java.nio.file.Path;
import org.eclipse.jetty.ee9.maven.plugin.MavenQuickStartConfiguration;
import org.eclipse.jetty.ee9.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee9.maven.plugin.ServerSupport;
import org.eclipse.jetty.ee9.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.ee9.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.ee9.webapp.Configuration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class QuickStartGenerator {
    private final Path quickstartXml;
    private final MavenWebAppContext webApp;
    private Path webAppPropsFile;
    private String contextXml;
    private boolean prepared = false;
    private Server server;
    private QueuedThreadPool tpool;

    public QuickStartGenerator(Path quickstartXml, MavenWebAppContext webApp) throws Exception {
        this.quickstartXml = quickstartXml;
        this.webApp = webApp == null ? new MavenWebAppContext() : webApp;
    }

    public MavenWebAppContext getWebApp() {
        return this.webApp;
    }

    public Path getQuickstartXml() {
        return this.quickstartXml;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Path getWebAppPropsFile() {
        return this.webAppPropsFile;
    }

    public void setWebAppPropsFile(Path webAppPropsFile) {
        this.webAppPropsFile = webAppPropsFile;
    }

    public String getContextXml() {
        return this.contextXml;
    }

    public void setContextXml(String contextXml) {
        this.contextXml = contextXml;
    }

    private void prepareWebApp() throws Exception {
        this.webApp.addConfiguration(new Configuration[]{new MavenQuickStartConfiguration()});
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.mode", QuickStartConfiguration.Mode.GENERATE);
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.xml", this.quickstartXml);
        this.webApp.setAttribute("org.eclipse.jetty.quickstart.origin", "o");
        this.webApp.setCopyWebDir(false);
        this.webApp.setCopyWebInf(false);
    }

    public void generate() throws Exception {
        if (this.quickstartXml == null) {
            throw new IllegalStateException("No quickstart xml output file");
        }
        if (!this.prepared) {
            this.prepared = true;
            this.prepareWebApp();
            if (this.server == null) {
                this.server = new Server();
            }
            ServerSupport.configureHandlers(this.server, null, null);
            ServerSupport.configureDefaultConfigurationClasses(this.server);
            if (this.tpool == null) {
                this.tpool = (QueuedThreadPool)this.server.getBean(QueuedThreadPool.class);
            }
            ServerSupport.addWebApplication(this.server, this.webApp);
            this.webApp.setPersistTempDirectory(true);
        }
        try {
            if (this.tpool != null) {
                this.tpool.start();
            } else {
                this.webApp.setAttribute("org.eclipse.jetty.ee9.annotations.multiThreaded", Boolean.FALSE.toString());
            }
            this.webApp.getCoreContextHandler().start();
            if (this.webAppPropsFile != null) {
                WebAppPropertyConverter.toProperties(this.webApp, this.webAppPropsFile.toFile(), this.contextXml);
            }
        }
        finally {
            this.webApp.getCoreContextHandler().stop();
            if (this.tpool != null) {
                this.tpool.stop();
            }
        }
    }
}

