/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.osgi.annotations;

import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.osgi.BundleIndex;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationParser
extends org.eclipse.jetty.annotations.AnnotationParser {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationParser.class);
    private final Set<URI> _parsed = ConcurrentHashMap.newKeySet();
    private final BundleIndex _bundleIndex = new BundleIndex();

    public BundleIndex getBundleIndex() {
        return this._bundleIndex;
    }

    public void parse(Set<? extends AnnotationParser.Handler> handlers, Bundle bundle) throws Exception {
        Resource bundleResource = this._bundleIndex.getResource(bundle);
        if (bundleResource == null) {
            return;
        }
        if (!this._parsed.add(this._bundleIndex.getURI(bundle))) {
            return;
        }
        this.parse(handlers, bundleResource);
    }

    public void parse(Set<? extends AnnotationParser.Handler> handlers, Resource r) throws Exception {
        block7: {
            if (r == null) {
                return;
            }
            if (!Resources.exists((Resource)r)) {
                return;
            }
            if (FileID.isJavaArchive((Path)r.getPath())) {
                this.parseJar(handlers, r);
                return;
            }
            if (r.isDirectory()) {
                this.parseDir(handlers, r);
                return;
            }
            if (FileID.isClassFile((Path)r.getPath())) {
                this.parseClass(handlers, null, r);
            }
            try {
                this.parseJar(handlers, r);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.warn("Resource not able to be scanned for classes: {}", (Object)r);
            }
        }
    }
}

