/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flusher {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Entry> queue = new ArrayDeque<Entry>();
    private final FlushCallback flushCallback = new FlushCallback();
    private final EndPoint endPoint;

    public Flusher(EndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public Callback cancel(Throwable cause) {
        CancelSendException cancelSendException = new CancelSendException(cause);
        if (!this.flushCallback.abort(cancelSendException)) {
            return Callback.NOOP;
        }
        Callback writeCallback = this.endPoint.cancelWrite(cause);
        if (writeCallback == null) {
            cancelSendException.complete();
        } else {
            writeCallback.failed(cause);
        }
        return cancelSendException.join();
    }

    public void flush(ByteBufferPool.Accumulator accumulator, Callback callback) {
        this.offer(new Entry(accumulator, callback));
        this.flushCallback.iterate();
    }

    private void offer(Entry entry) {
        try (AutoLock ignored = this.lock.lock();){
            this.queue.offer(entry);
        }
    }

    private Entry poll() {
        try (AutoLock ignored = this.lock.lock();){
            Entry entry = this.queue.poll();
            return entry;
        }
    }

    public void shutdown() {
        this.flush(null, Callback.from(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutting down {}", (Object)this.endPoint);
            }
            this.endPoint.shutdownOutput();
        }));
    }

    private class FlushCallback
    extends IteratingCallback {
        private Entry active;

        private FlushCallback() {
        }

        protected IteratingCallback.Action process() throws Exception {
            Entry entry = Flusher.this.poll();
            if (entry == null) {
                return IteratingCallback.Action.IDLE;
            }
            this.active = entry;
            List buffers = entry.accumulator.getByteBuffers();
            Flusher.this.endPoint.write((Callback)this, (ByteBuffer[])buffers.toArray(ByteBuffer[]::new));
            return IteratingCallback.Action.SCHEDULED;
        }

        protected void onAborted(Throwable cause) {
            if (cause instanceof CancelSendException) {
                CancelSendException cancelSend = (CancelSendException)cause;
                cancelSend.setCallback(this.resetCallback());
            }
        }

        private Callback resetCallback() {
            Entry entry = this.active;
            this.active = null;
            return Callback.from((Callback)entry.callback, entry::release);
        }

        protected void onCompleted(Throwable causeOrNull) {
            if (causeOrNull instanceof CancelSendException) {
                CancelSendException cancelSendException = (CancelSendException)causeOrNull;
                cancelSendException.complete();
            }
            super.onCompleted(causeOrNull);
        }

        protected void onCompleteSuccess() {
            throw new IllegalStateException();
        }

        protected void onSuccess() {
            if (this.active != null) {
                this.active.release();
                this.active.succeeded();
                this.active = null;
            }
        }

        public void onFailure(Throwable cause) {
            ArrayList<Entry> entries;
            if (this.active != null) {
                this.active.failed(cause);
            }
            try (AutoLock ignored = Flusher.this.lock.lock();){
                entries = new ArrayList<Entry>(Flusher.this.queue);
            }
            entries.forEach(entry -> entry.failed(cause));
        }

        protected void onCompleteFailure(Throwable cause) {
            ArrayList<Entry> entries;
            if (this.active != null) {
                this.active.release();
                this.active = null;
            }
            try (AutoLock ignored = Flusher.this.lock.lock();){
                entries = new ArrayList<Entry>(Flusher.this.queue);
                Flusher.this.queue.clear();
            }
            entries.forEach(Entry::release);
        }
    }

    private static class CancelSendException
    extends IOException {
        private final CountDownLatch _complete = new CountDownLatch(2);
        private Callback _callback;

        public CancelSendException(Throwable cause) {
            super(cause);
        }

        public void complete() {
            this._complete.countDown();
        }

        public Callback join() {
            try {
                this._complete.await();
            }
            catch (InterruptedException x) {
                Throwable cause = this.getCause();
                if (cause == null) {
                    throw new RuntimeException(x);
                }
                ExceptionUtil.addSuppressedIfNotAssociated((Throwable)cause, (Throwable)x);
                throw ExceptionUtil.asRuntimeException((Throwable)cause);
            }
            return this._callback;
        }

        public void setCallback(Callback callback) {
            this._callback = callback;
            this._complete.countDown();
        }
    }

    private record Entry(ByteBufferPool.Accumulator accumulator, Callback callback) {
        public void succeeded() {
            this.callback.succeeded();
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }

        private void release() {
            if (this.accumulator != null) {
                this.accumulator.release();
            }
        }
    }
}

