/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.util.Comparator;
import org.eclipse.jetty.util.Index;

public class HTTP2Cipher {
    public static final Comparator<String> COMPARATOR = new CipherComparator();
    private static final Index<Boolean> __blackProtocols = new Index.Builder().caseSensitive(false).with("TLSv1.2", (Object)Boolean.TRUE).with("TLSv1.1", (Object)Boolean.TRUE).with("TLSv1", (Object)Boolean.TRUE).with("SSL", (Object)Boolean.TRUE).with("SSLv2", (Object)Boolean.TRUE).with("SSLv3", (Object)Boolean.TRUE).build();
    private static final Index<Boolean> __blackCiphers = new Index.Builder().caseSensitive(false).with("TLS_NULL_WITH_NULL_NULL", (Object)Boolean.TRUE).with("TLS_RSA_WITH_NULL_MD5", (Object)Boolean.TRUE).with("TLS_RSA_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_RSA_EXPORT_WITH_RC4_40_MD5", (Object)Boolean.TRUE).with("TLS_RSA_WITH_RC4_128_MD5", (Object)Boolean.TRUE).with("TLS_RSA_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", (Object)Boolean.TRUE).with("TLS_RSA_WITH_IDEA_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_RC4_128_MD5", (Object)Boolean.TRUE).with("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_DES_CBC_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_IDEA_CBC_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_DES_CBC_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_RC4_128_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_WITH_IDEA_CBC_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", (Object)Boolean.TRUE).with("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", (Object)Boolean.TRUE).with("TLS_PSK_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_NULL_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_PSK_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_PSK_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_SEED_CBC_SHA", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_NULL_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_NULL_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_NULL_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_NULL_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_NULL_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_NULL_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_anon_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_anon_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_RC4_128_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_NULL_SHA", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_NULL_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_NULL_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384", (Object)Boolean.TRUE).with("TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", (Object)Boolean.TRUE).with("TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_128_CCM", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_256_CCM", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_128_CCM_8", (Object)Boolean.TRUE).with("TLS_RSA_WITH_AES_256_CCM_8", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_128_CCM", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_256_CCM", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_128_CCM_8", (Object)Boolean.TRUE).with("TLS_PSK_WITH_AES_256_CCM_8", (Object)Boolean.TRUE).build();

    public static boolean isBlackListProtocol(String tlsProtocol) {
        return __blackProtocols.get(tlsProtocol) != null;
    }

    public static boolean isBlackListCipher(String tlsCipher) {
        return __blackCiphers.get(tlsCipher) != null;
    }

    public static class CipherComparator
    implements Comparator<String> {
        @Override
        public int compare(String c1, String c2) {
            boolean b2;
            boolean b1 = HTTP2Cipher.isBlackListCipher(c1);
            if (b1 == (b2 = HTTP2Cipher.isBlackListCipher(c2))) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
    }
}

