//
//  ========================================================================
//  Copyright (c) 1995-2014 Mort Bay Consulting Pty. Ltd.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;

import org.eclipse.jetty.http.MetaData;

public class ContinuationBodyParser extends BodyParser
{
    private final HeaderBlockParser headerBlockParser;

    public ContinuationBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser)
    {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
    }

    @Override
    public Result parse(ByteBuffer buffer)
    {
        MetaData metaData = headerBlockParser.parse(buffer, getBodyLength());
        if (metaData != null)
        {
            // TODO: CONTINUATION frames are not supported for now, we just parse them to keep HPACK happy.
            return Result.ASYNC;
        }
        return Result.PENDING;
    }
}
