/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class WindowUpdateGenerator
extends FrameGenerator {
    public WindowUpdateGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public void generate(ByteBufferPool.Lease lease, Frame frame) {
        WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
        this.generateWindowUpdate(lease, windowUpdateFrame.getStreamId(), windowUpdateFrame.getWindowDelta());
    }

    public void generateWindowUpdate(ByteBufferPool.Lease lease, int streamId, int windowUpdate) {
        ByteBuffer header;
        if (windowUpdate < 0) {
            throw new IllegalArgumentException("Invalid window update: " + windowUpdate);
        }
        boolean both = false;
        if (streamId < 0) {
            both = true;
            streamId = -streamId;
        }
        if (both) {
            header = this.generateHeader(lease, FrameType.WINDOW_UPDATE, 4, 0, 0);
            header.putInt(windowUpdate);
            BufferUtil.flipToFlush((ByteBuffer)header, (int)0);
            lease.append(header, true);
        }
        header = this.generateHeader(lease, FrameType.WINDOW_UPDATE, 4, 0, streamId);
        header.putInt(windowUpdate);
        BufferUtil.flipToFlush((ByteBuffer)header, (int)0);
        lease.append(header, true);
    }
}

