/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderBlockParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersBodyParser
extends BodyParser {
    private final HeaderBlockParser headerBlockParser;
    private State state = State.PREPARE;
    private int cursor;
    private int length;
    private int paddingLength;
    private boolean exclusive;
    private int streamId;
    private int weight;

    public HeadersBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.length = 0;
        this.paddingLength = 0;
        this.exclusive = false;
        this.streamId = 0;
        this.weight = 0;
    }

    @Override
    protected boolean emptyBody() {
        MetaData metaData = this.headerBlockParser.parse(BufferUtil.EMPTY_BUFFER, 0);
        boolean result = this.onHeaders(0, 0, false, metaData);
        this.reset();
        return result;
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        boolean loop = false;
        block10: while (buffer.hasRemaining() || loop) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() == 0) {
                        return this.notifyConnectionFailure(1, "invalid_headers_frame");
                    }
                    if (!this.hasFlag(4)) {
                        return this.notifyConnectionFailure(2, "unsupported_headers_frame");
                    }
                    this.length = this.getBodyLength();
                    if (this.isPadding()) {
                        this.state = State.PADDING_LENGTH;
                        continue block10;
                    }
                    if (this.hasFlag(32)) {
                        this.state = State.EXCLUSIVE;
                        continue block10;
                    }
                    this.state = State.HEADERS;
                    continue block10;
                }
                case PADDING_LENGTH: {
                    this.paddingLength = buffer.get() & 0xFF;
                    --this.length;
                    this.length -= this.paddingLength;
                    this.state = this.hasFlag(32) ? State.EXCLUSIVE : State.HEADERS;
                    boolean bl = loop = this.length == 0;
                    if (this.length >= 0) continue block10;
                    return this.notifyConnectionFailure(6, "invalid_headers_frame_padding");
                }
                case EXCLUSIVE: {
                    byte currByte = buffer.get(buffer.position());
                    this.exclusive = (currByte & 0x80) == 128;
                    this.state = State.STREAM_ID;
                    continue block10;
                }
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt();
                        this.streamId &= Integer.MAX_VALUE;
                        this.length -= 4;
                        this.state = State.WEIGHT;
                        if (this.length >= 1) continue block10;
                        return this.notifyConnectionFailure(6, "invalid_headers_frame");
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block10;
                }
                case STREAM_ID_BYTES: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.streamId += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.cursor > 0 && this.length <= 0) {
                        return this.notifyConnectionFailure(6, "invalid_headers_frame");
                    }
                    if (this.cursor != 0) continue block10;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.WEIGHT;
                    if (this.length >= 1) continue block10;
                    return this.notifyConnectionFailure(6, "invalid_headers_frame");
                }
                case WEIGHT: {
                    this.weight = buffer.get() & 0xFF;
                    --this.length;
                    this.state = State.HEADERS;
                    loop = this.length == 0;
                    continue block10;
                }
                case HEADERS: {
                    MetaData metaData = this.headerBlockParser.parse(buffer, this.length);
                    if (metaData == null) continue block10;
                    this.state = State.PADDING;
                    boolean bl = loop = this.paddingLength == 0;
                    if (!this.onHeaders(this.streamId, this.weight, this.exclusive, metaData)) continue block10;
                    return BodyParser.Result.ASYNC;
                }
                case PADDING: {
                    int size = Math.min(buffer.remaining(), this.paddingLength);
                    buffer.position(buffer.position() + size);
                    this.paddingLength -= size;
                    if (this.paddingLength != 0) continue block10;
                    this.reset();
                    return BodyParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.PENDING;
    }

    private boolean onHeaders(int streamId, int weight, boolean exclusive, MetaData metaData) {
        PriorityFrame priorityFrame = null;
        if (this.hasFlag(32)) {
            priorityFrame = new PriorityFrame(streamId, this.getStreamId(), weight, exclusive);
        }
        HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, priorityFrame, this.isEndStream());
        return this.notifyHeaders(frame);
    }

    private static enum State {
        PREPARE,
        PADDING_LENGTH,
        EXCLUSIVE,
        STREAM_ID,
        STREAM_ID_BYTES,
        WEIGHT,
        HEADERS,
        PADDING;

    }
}

