/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.HeaderBlockParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.Parser;

public class PushPromiseBodyParser
extends BodyParser {
    private final HeaderBlockParser headerBlockParser;
    private State state = State.PREPARE;
    private int cursor;
    private int length;
    private int paddingLength;
    private int streamId;

    public PushPromiseBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.length = 0;
        this.paddingLength = 0;
        this.streamId = 0;
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        boolean loop = false;
        block8: while (buffer.hasRemaining() || loop) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() == 0) {
                        return this.notifyConnectionFailure(1, "invalid_push_promise_frame");
                    }
                    if (!this.hasFlag(4)) {
                        return this.notifyConnectionFailure(2, "unsupported_push_promise_frame");
                    }
                    this.length = this.getBodyLength();
                    if (this.isPadding()) {
                        this.state = State.PADDING_LENGTH;
                        continue block8;
                    }
                    this.state = State.STREAM_ID;
                    continue block8;
                }
                case PADDING_LENGTH: {
                    this.paddingLength = buffer.get() & 0xFF;
                    --this.length;
                    this.length -= this.paddingLength;
                    this.state = State.STREAM_ID;
                    if (this.length >= 4) continue block8;
                    return this.notifyConnectionFailure(6, "invalid_push_promise_frame");
                }
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt();
                        this.streamId &= Integer.MAX_VALUE;
                        this.length -= 4;
                        this.state = State.HEADERS;
                        loop = this.length == 0;
                        continue block8;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block8;
                }
                case STREAM_ID_BYTES: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.streamId += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.cursor > 0 && this.length <= 0) {
                        return this.notifyConnectionFailure(6, "invalid_push_promise_frame");
                    }
                    if (this.cursor != 0) continue block8;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.HEADERS;
                    loop = this.length == 0;
                    continue block8;
                }
                case HEADERS: {
                    MetaData metaData = this.headerBlockParser.parse(buffer, this.length);
                    if (metaData == null) continue block8;
                    this.state = State.PADDING;
                    boolean bl = loop = this.paddingLength == 0;
                    if (!this.onPushPromise(this.streamId, metaData)) continue block8;
                    return BodyParser.Result.ASYNC;
                }
                case PADDING: {
                    int size = Math.min(buffer.remaining(), this.paddingLength);
                    buffer.position(buffer.position() + size);
                    this.paddingLength -= size;
                    if (this.paddingLength != 0) continue block8;
                    this.reset();
                    return BodyParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return BodyParser.Result.PENDING;
    }

    private boolean onPushPromise(int streamId, MetaData metaData) {
        PushPromiseFrame frame = new PushPromiseFrame(this.getStreamId(), streamId, metaData);
        return this.notifyPushPromise(frame);
    }

    private static enum State {
        PREPARE,
        PADDING_LENGTH,
        STREAM_ID,
        STREAM_ID_BYTES,
        HEADERS,
        PADDING;

    }
}

