/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Connection
extends AbstractConnection {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize, boolean dispatchIO) {
        super(endPoint, executor, dispatchIO);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
    }

    protected ISession getSession() {
        return this.session;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", new Object[]{this});
        }
        super.onOpen();
        this.fillInterested();
    }

    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", new Object[]{this});
        }
        super.onClose();
    }

    public void onFillable() {
        ByteBuffer buffer = this.byteBufferPool.acquire(this.bufferSize, false);
        boolean readMore = this.read(buffer) == 0;
        this.byteBufferPool.release(buffer);
        if (readMore) {
            this.fillInterested();
        }
    }

    protected int read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        int filled;
        while ((filled = this.fill(endPoint, buffer)) != 0) {
            if (filled < 0) {
                this.session.onShutdown();
                return -1;
            }
            this.parser.parse(buffer);
        }
        return 0;
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            LOG.debug("Could not read from " + endPoint, (Throwable)x);
            return -1;
        }
    }

    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", new Object[]{this.getEndPoint().getIdleTimeout(), this});
        }
        this.session.onIdleTimeout();
        return false;
    }
}

