/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.hpack.HpackDecoder;
import org.eclipse.jetty.http2.parser.BodyParser;
import org.eclipse.jetty.http2.parser.ContinuationBodyParser;
import org.eclipse.jetty.http2.parser.DataBodyParser;
import org.eclipse.jetty.http2.parser.GoAwayBodyParser;
import org.eclipse.jetty.http2.parser.HeaderBlockParser;
import org.eclipse.jetty.http2.parser.HeaderParser;
import org.eclipse.jetty.http2.parser.HeadersBodyParser;
import org.eclipse.jetty.http2.parser.PingBodyParser;
import org.eclipse.jetty.http2.parser.PriorityBodyParser;
import org.eclipse.jetty.http2.parser.PushPromiseBodyParser;
import org.eclipse.jetty.http2.parser.ResetBodyParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.parser.WindowUpdateBodyParser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Parser {
    private static final Logger LOG = Log.getLogger(Parser.class);
    private final Listener listener;
    private final HeaderParser headerParser;
    private final BodyParser[] bodyParsers;
    private State state = State.HEADER;

    public Parser(ByteBufferPool byteBufferPool, Listener listener, int maxHeaderTableSize, int maxHeaderSize) {
        this.listener = listener;
        this.headerParser = new HeaderParser();
        this.bodyParsers = new BodyParser[FrameType.values().length];
        HeaderBlockParser headerBlockParser = new HeaderBlockParser(byteBufferPool, new HpackDecoder(maxHeaderTableSize, maxHeaderSize));
        this.bodyParsers[FrameType.DATA.getType()] = new DataBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.HEADERS.getType()] = new HeadersBodyParser(this.headerParser, listener, headerBlockParser);
        this.bodyParsers[FrameType.PRIORITY.getType()] = new PriorityBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.RST_STREAM.getType()] = new ResetBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.SETTINGS.getType()] = new SettingsBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.PUSH_PROMISE.getType()] = new PushPromiseBodyParser(this.headerParser, listener, headerBlockParser);
        this.bodyParsers[FrameType.PING.getType()] = new PingBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.GO_AWAY.getType()] = new GoAwayBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.CONTINUATION.getType()] = new ContinuationBodyParser(this.headerParser, listener, headerBlockParser);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
    }

    public boolean parse(ByteBuffer buffer) {
        try {
            block11: while (true) {
                switch (this.state) {
                    case HEADER: {
                        if (!this.headerParser.parse(buffer)) {
                            return false;
                        }
                        this.state = State.BODY;
                        continue block11;
                    }
                    case BODY: {
                        int type = this.headerParser.getFrameType();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Parsing {} frame", new Object[]{FrameType.from(type)});
                        }
                        if (type < 0 || type >= this.bodyParsers.length) {
                            this.notifyConnectionFailure(1, "unknown_frame_type_" + type);
                            return false;
                        }
                        BodyParser bodyParser = this.bodyParsers[type];
                        if (this.headerParser.getLength() == 0) {
                            boolean async = bodyParser.emptyBody();
                            this.reset();
                            if (async) {
                                return true;
                            }
                            if (buffer.hasRemaining()) continue block11;
                            return false;
                        }
                        BodyParser.Result result = bodyParser.parse(buffer);
                        switch (result) {
                            case PENDING: {
                                return false;
                            }
                            case ASYNC: {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Parsed  {} frame, asynchronous processing", new Object[]{FrameType.from(type)});
                                }
                                return true;
                            }
                            case COMPLETE: {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Parsed  {} frame, synchronous processing", new Object[]{FrameType.from(type)});
                                }
                                this.reset();
                                continue block11;
                            }
                        }
                        throw new IllegalStateException();
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            this.notifyConnectionFailure(1, "parser_error");
            return false;
        }
    }

    protected void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public boolean onData(DataFrame var1);

        public boolean onHeaders(HeadersFrame var1);

        public boolean onPriority(PriorityFrame var1);

        public boolean onReset(ResetFrame var1);

        public boolean onSettings(SettingsFrame var1);

        public boolean onPushPromise(PushPromiseFrame var1);

        public boolean onPing(PingFrame var1);

        public boolean onGoAway(GoAwayFrame var1);

        public boolean onWindowUpdate(WindowUpdateFrame var1);

        public void onConnectionFailure(int var1, String var2);

        public static class Adapter
        implements Listener {
            @Override
            public boolean onData(DataFrame frame) {
                return false;
            }

            @Override
            public boolean onHeaders(HeadersFrame frame) {
                return false;
            }

            @Override
            public boolean onPriority(PriorityFrame frame) {
                return false;
            }

            @Override
            public boolean onReset(ResetFrame frame) {
                return false;
            }

            @Override
            public boolean onSettings(SettingsFrame frame) {
                return false;
            }

            @Override
            public boolean onPushPromise(PushPromiseFrame frame) {
                return false;
            }

            @Override
            public boolean onPing(PingFrame frame) {
                return false;
            }

            @Override
            public boolean onGoAway(GoAwayFrame frame) {
                return false;
            }

            @Override
            public boolean onWindowUpdate(WindowUpdateFrame frame) {
                return false;
            }

            @Override
            public void onConnectionFailure(int error, String reason) {
                LOG.warn("Connection failure: {}/{}", new Object[]{error, reason});
            }
        }
    }
}

