/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class DataGenerator {
    private final HeaderGenerator headerGenerator;

    public DataGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public int generate(ByteBufferPool.Lease lease, DataFrame frame, int maxLength) {
        return this.generateData(lease, frame.getStreamId(), frame.getData(), frame.isEndStream(), maxLength);
    }

    public int generateData(ByteBufferPool.Lease lease, int streamId, ByteBuffer data, boolean last, int maxLength) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int dataLength = data.remaining();
        int maxFrameSize = this.headerGenerator.getMaxFrameSize();
        if (dataLength <= maxLength && dataLength <= maxFrameSize) {
            return this.generateFrame(lease, streamId, data, last);
        }
        int length = Math.min(maxLength, dataLength);
        int frames = length / maxFrameSize;
        if (frames * maxFrameSize != length) {
            ++frames;
        }
        int totalLength = 0;
        int begin = data.position();
        int end = data.limit();
        for (int i = 1; i <= frames; ++i) {
            int limit = begin + Math.min(maxFrameSize * i, length);
            data.limit(limit);
            ByteBuffer slice = data.slice();
            data.position(limit);
            totalLength += this.generateFrame(lease, streamId, slice, i == frames && last && limit == end);
        }
        data.limit(end);
        return totalLength;
    }

    private int generateFrame(ByteBufferPool.Lease lease, int streamId, ByteBuffer data, boolean last) {
        int length = data.remaining();
        int flags = 0;
        if (last) {
            flags |= 1;
        }
        ByteBuffer header = this.headerGenerator.generate(lease, FrameType.DATA, 9 + length, length, flags, streamId);
        BufferUtil.flipToFlush((ByteBuffer)header, (int)0);
        lease.append(header, true);
        lease.append(data, false);
        return 9 + length;
    }
}

