/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;

public class HTTP2Connection
extends AbstractConnection {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private final Queue<Runnable> tasks = new ConcurrentArrayQueue();
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;
    private final HTTP2Producer producer = new HTTP2Producer();
    private final ExecutionStrategy executionStrategy;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
        this.executionStrategy = ExecutionStrategy.Factory.instanceFor((ExecutionStrategy.Producer)this.producer, (Executor)executor);
    }

    public ISession getSession() {
        return this.session;
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void setInputBuffer(ByteBuffer buffer) {
        this.producer.buffer = buffer;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", new Object[]{this});
        }
        super.onOpen();
        this.executionStrategy.execute();
    }

    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", new Object[]{this});
        }
        super.onClose();
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", new Object[]{this});
        }
        this.executionStrategy.execute();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            LOG.debug("Could not read from " + endPoint, (Throwable)x);
            return -1;
        }
    }

    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", new Object[]{this.getEndPoint().getIdleTimeout(), this});
        }
        this.session.onIdleTimeout();
        return false;
    }

    protected void offerTask(Runnable task, boolean dispatch) {
        this.tasks.offer(task);
        if (dispatch) {
            this.executionStrategy.dispatch();
        } else {
            this.executionStrategy.execute();
        }
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private ByteBuffer buffer;

        protected HTTP2Producer() {
        }

        public Runnable produce() {
            Runnable task = (Runnable)HTTP2Connection.this.tasks.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", new Object[]{task});
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested()) {
                return null;
            }
            if (this.buffer == null) {
                this.buffer = HTTP2Connection.this.byteBufferPool.acquire(HTTP2Connection.this.bufferSize, false);
            }
            boolean looping = BufferUtil.hasContent((ByteBuffer)this.buffer);
            while (true) {
                if (looping) {
                    while (this.buffer.hasRemaining()) {
                        HTTP2Connection.this.parser.parse(this.buffer);
                    }
                    task = (Runnable)HTTP2Connection.this.tasks.poll();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dequeued task {}", new Object[]{task});
                    }
                    if (task != null) {
                        this.release();
                        return task;
                    }
                }
                int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes", (long)filled);
                }
                if (filled == 0) {
                    this.release();
                    HTTP2Connection.this.fillInterested();
                    return null;
                }
                if (filled < 0) {
                    this.release();
                    HTTP2Connection.this.session.onShutdown();
                    return null;
                }
                looping = true;
            }
        }

        private void release() {
            if (this.buffer != null && !this.buffer.hasRemaining()) {
                HTTP2Connection.this.byteBufferPool.release(this.buffer);
                this.buffer = null;
            }
        }
    }
}

