/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http2.AbstractFlowControlStrategy;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.Atomics;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class BufferingFlowControlStrategy
extends AbstractFlowControlStrategy {
    private final AtomicInteger maxSessionRecvWindow = new AtomicInteger(65535);
    private final AtomicInteger sessionLevel = new AtomicInteger();
    private final Map<IStream, AtomicInteger> streamLevels = new ConcurrentHashMap<IStream, AtomicInteger>();
    private float bufferRatio;

    public BufferingFlowControlStrategy(float bufferRatio) {
        this(65535, bufferRatio);
    }

    public BufferingFlowControlStrategy(int initialStreamSendWindow, float bufferRatio) {
        super(initialStreamSendWindow);
        this.bufferRatio = bufferRatio;
    }

    @ManagedAttribute(value="The ratio between the receive buffer and the consume buffer")
    public float getBufferRatio() {
        return this.bufferRatio;
    }

    public void setBufferRatio(float bufferRatio) {
        this.bufferRatio = bufferRatio;
    }

    @Override
    public void onStreamCreated(IStream stream) {
        super.onStreamCreated(stream);
        this.streamLevels.put(stream, new AtomicInteger());
    }

    @Override
    public void onStreamDestroyed(IStream stream) {
        this.streamLevels.remove(stream);
        super.onStreamDestroyed(stream);
    }

    @Override
    public void onDataConsumed(ISession session, IStream stream, int length) {
        int maxLevel;
        if (length <= 0) {
            return;
        }
        float ratio = this.bufferRatio;
        WindowUpdateFrame windowFrame = null;
        int level = this.sessionLevel.addAndGet(length);
        if (level > (maxLevel = (int)((float)this.maxSessionRecvWindow.get() * ratio))) {
            level = this.sessionLevel.getAndSet(0);
            session.updateRecvWindow(level);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data consumed, updated session recv window by {}/{} for {}", new Object[]{level, maxLevel, session});
            }
            windowFrame = new WindowUpdateFrame(0, level);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Data consumed, session recv window level {}/{} for {}", new Object[]{level, maxLevel, session});
        }
        Frame[] windowFrames = Frame.EMPTY_ARRAY;
        if (stream != null) {
            if (stream.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Data consumed, ignoring update stream recv window by {} for closed {}", new Object[]{length, stream});
                }
            } else {
                AtomicInteger streamLevel = this.streamLevels.get(stream);
                if (streamLevel != null) {
                    level = streamLevel.addAndGet(length);
                    if (level > (maxLevel = (int)((float)this.getInitialStreamRecvWindow() * ratio))) {
                        level = streamLevel.getAndSet(0);
                        stream.updateRecvWindow(level);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Data consumed, updated stream recv window by {}/{} for {}", new Object[]{level, maxLevel, stream});
                        }
                        WindowUpdateFrame frame = new WindowUpdateFrame(stream.getId(), level);
                        if (windowFrame == null) {
                            windowFrame = frame;
                        } else {
                            windowFrames = new Frame[]{frame};
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Data consumed, stream recv window level {}/{} for {}", new Object[]{level, maxLevel, session});
                    }
                }
            }
        }
        if (windowFrame != null) {
            session.frames(stream, Callback.NOOP, windowFrame, windowFrames);
        }
    }

    @Override
    public void windowUpdate(ISession session, IStream stream, WindowUpdateFrame frame) {
        super.windowUpdate(session, stream, frame);
        if (frame.getStreamId() == 0) {
            int sessionWindow = session.updateRecvWindow(0);
            Atomics.updateMax((AtomicInteger)this.maxSessionRecvWindow, (int)sessionWindow);
        }
    }

    public String toString() {
        return String.format("%s@%x[ratio=%.2f,sessionStallTime=%dms,streamsStallTime=%dms]", this.getClass().getSimpleName(), this.hashCode(), Float.valueOf(this.bufferRatio), this.getSessionStallTime(), this.getStreamsStallTime());
    }
}

