/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;
    private MetaData metaData;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", new Object[]{this, stream.getId()});
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    public void send(MetaData.Response info, boolean isHeadRequest, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (info != null) {
            boolean informational;
            this.metaData = info;
            int status = info.getStatus();
            boolean bl2 = informational = HttpStatus.isInformational((int)status) && status != 101;
            if (informational) {
                if (this.transportCallback.start(callback, false)) {
                    this.sendHeaders(info, false, this.transportCallback);
                }
            } else {
                boolean needsCommit = this.commit.compareAndSet(false, true);
                if (needsCommit) {
                    Supplier trailers = info.getTrailerSupplier();
                    if (hasContent) {
                        Object nested = trailers == null || !lastContent ? callback : new SendTrailers(callback);
                        Callback.Nested commitCallback = new Callback.Nested((Callback)nested, (Callback)nested, content, lastContent, trailers){
                            final /* synthetic */ Callback val$nested;
                            final /* synthetic */ ByteBuffer val$content;
                            final /* synthetic */ boolean val$lastContent;
                            final /* synthetic */ Supplier val$trailers;
                            {
                                this.val$nested = callback;
                                this.val$content = byteBuffer;
                                this.val$lastContent = bl;
                                this.val$trailers = supplier;
                                super(x0);
                            }

                            public void succeeded() {
                                if (HttpTransportOverHTTP2.this.transportCallback.start(this.val$nested, false)) {
                                    HttpTransportOverHTTP2.this.sendContent(this.val$content, this.val$lastContent, this.val$trailers == null && this.val$lastContent, HttpTransportOverHTTP2.this.transportCallback);
                                }
                            }
                        };
                        if (this.transportCallback.start((Callback)commitCallback, true)) {
                            this.sendHeaders(info, false, this.transportCallback);
                        }
                    } else {
                        Object nested;
                        Object object = nested = trailers == null ? callback : new SendTrailers(callback);
                        if (this.transportCallback.start((Callback)nested, true)) {
                            this.sendHeaders(info, trailers == null && lastContent, this.transportCallback);
                        }
                    }
                } else {
                    callback.failed((Throwable)new IllegalStateException("committed"));
                }
            }
        } else if (hasContent || lastContent) {
            Object nested;
            Supplier trailers = this.metaData.getTrailerSupplier();
            Object object = nested = trailers == null ? callback : new SendTrailers(callback);
            if (this.transportCallback.start((Callback)nested, false)) {
                this.sendContent(content, lastContent, trailers == null && lastContent, this.transportCallback);
            }
        } else {
            callback.succeeded();
        }
    }

    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", new Object[]{request});
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", new Object[]{request});
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), 0, (MetaData)request), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, (Stream.Listener)new Stream.Listener.Adapter());
    }

    private void sendHeaders(MetaData.Response info, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, endStream);
        this.stream.headers(frame, callback);
    }

    private void sendContent(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, endStream);
        this.stream.data(frame, callback);
    }

    private void sendTrailers(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode())});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), metaData, null, true);
        this.stream.headers(frame, callback);
    }

    public void onStreamFailure(Throwable failure) {
        this.transportCallback.failed(failure);
    }

    public boolean onStreamTimeout(Throwable failure) {
        return this.transportCallback.onIdleTimeout(failure);
    }

    public void onCompleted() {
        HttpChannelOverHTTP2 channel;
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}: unconsumed request content, resetting stream", (long)this.stream.getId());
            }
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        if ((channel = (HttpChannelOverHTTP2)((Object)this.stream.getAttribute(IStream.CHANNEL_ATTRIBUTE))) != null) {
            channel.consumeInput();
        }
    }

    public void abort(Throwable failure) {
        IStream stream = this.stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{} aborted", new Object[]{stream == null ? -1 : stream.getId(), stream == null ? Integer.valueOf(-1) : Integer.toHexString(stream.getSession().hashCode())});
        }
        if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.INTERNAL_ERROR.code), Callback.NOOP);
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private SendTrailers(Callback callback) {
            super(callback);
        }

        public void succeeded() {
            if (HttpTransportOverHTTP2.this.transportCallback.start(this.getCallback(), false)) {
                HttpTransportOverHTTP2.this.sendTrailers(new MetaData(HttpVersion.HTTP_2, (HttpFields)HttpTransportOverHTTP2.this.metaData.getTrailerSupplier().get()), HttpTransportOverHTTP2.this.transportCallback);
            }
        }
    }

    private static enum State {
        IDLE,
        WRITING,
        FAILED,
        TIMEOUT;

    }

    private class TransportCallback
    implements Callback {
        private State state = State.IDLE;
        private Callback callback;
        private Throwable failure;
        private boolean commit;

        private TransportCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start(Callback callback, boolean commit) {
            Throwable failure;
            State state;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                state = this.state;
                failure = this.failure;
                if (state == State.IDLE) {
                    this.state = State.WRITING;
                    this.callback = callback;
                    this.commit = commit;
                    return true;
                }
            }
            if (failure == null) {
                failure = new IllegalStateException("Invalid transport state: " + (Object)((Object)state));
            }
            callback.failed(failure);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state == State.WRITING) {
                    callback = this.callback;
                    this.callback = null;
                    this.state = State.IDLE;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}/{} {} {}", new Object[]{HttpTransportOverHTTP2.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP2.this.stream.getSession().hashCode()), commit ? "commit" : "flush", callback == null ? "failure" : "success"});
            }
            if (callback != null) {
                callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable failure) {
            boolean commit;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                commit = this.commit;
                if (this.state == State.WRITING) {
                    this.state = State.FAILED;
                    callback = this.callback;
                    this.callback = null;
                    this.failure = failure;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HTTP2 Response #%d/%h failed to %s", HttpTransportOverHTTP2.this.stream.getId(), HttpTransportOverHTTP2.this.stream.getSession(), commit ? "commit" : "flush"), failure);
            }
            if (callback != null) {
                callback.failed(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Invocable.InvocationType getInvocationType() {
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                callback = this.callback;
            }
            return callback != null ? callback.getInvocationType() : super.getInvocationType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean onIdleTimeout(Throwable failure) {
            boolean result;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                boolean bl = result = this.state == State.WRITING;
                if (result) {
                    this.state = State.TIMEOUT;
                    callback = this.callback;
                    this.callback = null;
                    this.failure = failure;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HTTP2 Response #%d/%h idle timeout", HttpTransportOverHTTP2.this.stream.getId(), HttpTransportOverHTTP2.this.stream.getSession()), failure);
            }
            if (result) {
                callback.failed(failure);
            }
            return result;
        }
    }
}

