/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory
implements NegotiatingServerConnection.CipherDiscriminator {
    private static final Logger LOG = Log.getLogger(HTTP2ServerConnectionFactory.class);

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        super(httpConfiguration);
    }

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerSessionListener(connector, endPoint);
    }

    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        boolean acceptable;
        boolean bl = acceptable = "h2-14".equals(protocol) || !HTTP2Cipher.isBlackListProtocol((String)tlsProtocol) || !HTTP2Cipher.isBlackListCipher((String)tlsCipher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("proto={} tls={} cipher={} 9.2.2-acceptable={}", new Object[]{protocol, tlsProtocol, tlsCipher, acceptable});
        }
        return acceptable;
    }

    protected class HTTPServerSessionListener
    extends ServerSessionListener.Adapter
    implements Stream.Listener {
        private final Connector connector;
        private final EndPoint endPoint;

        public HTTPServerSessionListener(Connector connector, EndPoint endPoint) {
            this.connector = connector;
            this.endPoint = endPoint;
        }

        protected HTTP2ServerConnection getConnection() {
            return (HTTP2ServerConnection)this.endPoint.getConnection();
        }

        public Map<Integer, Integer> onPreface(Session session) {
            HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
            settings.put(1, HTTP2ServerConnectionFactory.this.getMaxDynamicTableSize());
            settings.put(4, HTTP2ServerConnectionFactory.this.getInitialStreamRecvWindow());
            int maxConcurrentStreams = HTTP2ServerConnectionFactory.this.getMaxConcurrentStreams();
            if (maxConcurrentStreams >= 0) {
                settings.put(3, maxConcurrentStreams);
            }
            settings.put(6, HTTP2ServerConnectionFactory.this.getHttpConfiguration().getRequestHeaderSize());
            return settings;
        }

        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            this.getConnection().onNewStream(this.connector, (IStream)stream, frame);
            return this;
        }

        public boolean onIdleTimeout(Session session) {
            boolean close = super.onIdleTimeout(session);
            if (!close) {
                return false;
            }
            long idleTimeout = this.getConnection().getEndPoint().getIdleTimeout();
            return this.getConnection().onSessionTimeout(new TimeoutException("Session idle timeout " + idleTimeout + " ms"));
        }

        public void onClose(Session session, GoAwayFrame frame, Callback callback) {
            String reason;
            ErrorCode error = ErrorCode.from((int)frame.getError());
            if (error == null) {
                error = ErrorCode.STREAM_CLOSED_ERROR;
            }
            if ((reason = frame.tryConvertPayload()) != null && !reason.isEmpty()) {
                reason = " (" + reason + ")";
            }
            this.getConnection().onSessionFailure((Throwable)new EofException("HTTP/2 " + error + reason), callback);
        }

        public void onFailure(Session session, Throwable failure, Callback callback) {
            this.getConnection().onSessionFailure(failure, callback);
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            if (frame.isEndStream()) {
                this.getConnection().onTrailers((IStream)stream, frame);
            } else {
                this.close(stream, "invalid_trailers");
            }
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            this.close(stream, "push_promise");
            return null;
        }

        public void onData(Stream stream, DataFrame frame, Callback callback) {
            this.getConnection().onData((IStream)stream, frame, callback);
        }

        public void onReset(Stream stream, ResetFrame frame) {
            ErrorCode error = ErrorCode.from((int)frame.getError());
            if (error == null) {
                error = ErrorCode.CANCEL_STREAM_ERROR;
            }
            this.getConnection().onStreamFailure((IStream)stream, (Throwable)new EofException("HTTP/2 " + error), Callback.NOOP);
        }

        public boolean onIdleTimeout(Stream stream, Throwable x) {
            return this.getConnection().onStreamTimeout((IStream)stream, x);
        }

        private void close(Stream stream, String reason) {
            stream.getSession().close(ErrorCode.PROTOCOL_ERROR.code, reason, Callback.NOOP);
        }
    }
}

