/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http.compression.NBitStringEncoder;
import org.eclipse.jetty.http3.qpack.internal.table.Entry;

public abstract class EncodableEntry {
    public static EncodableEntry getReferencedEntry(Entry entry) {
        return new ReferencedEntry(entry);
    }

    public static EncodableEntry getNameReferencedEntry(Entry nameEntry, HttpField field, boolean huffman) {
        return new ReferencedNameEntry(nameEntry, field, huffman);
    }

    public static EncodableEntry getLiteralEntry(HttpField field, boolean huffman) {
        return new LiteralEntry(field, huffman);
    }

    public static EncodableEntry getPreEncodedEntry(PreEncodedHttpField httpField) {
        return new PreEncodedEntry(httpField);
    }

    public abstract void encode(ByteBuffer var1, int var2);

    public abstract int getRequiredSize(int var1);

    public abstract int getRequiredInsertCount();

    private static class ReferencedEntry
    extends EncodableEntry {
        private final Entry _entry;

        public ReferencedEntry(Entry entry) {
            this._entry = entry;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            boolean isStatic = this._entry.isStatic();
            if (isStatic) {
                buffer.put((byte)-64);
                int relativeIndex = this._entry.getIndex();
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)6, (long)relativeIndex);
            } else if (this._entry.getIndex() < base) {
                buffer.put((byte)-128);
                int relativeIndex = base - (this._entry.getIndex() + 1);
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)6, (long)relativeIndex);
            } else {
                buffer.put((byte)16);
                int relativeIndex = this._entry.getIndex() - base;
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)4, (long)relativeIndex);
            }
        }

        @Override
        public int getRequiredSize(int base) {
            boolean isStatic = this._entry.isStatic();
            if (isStatic) {
                int relativeIndex = this._entry.getIndex();
                return NBitIntegerEncoder.octetsNeeded((int)6, (long)relativeIndex);
            }
            if (this._entry.getIndex() < base) {
                int relativeIndex = base - (this._entry.getIndex() + 1);
                return NBitIntegerEncoder.octetsNeeded((int)6, (long)relativeIndex);
            }
            int relativeIndex = this._entry.getIndex() - base;
            return NBitIntegerEncoder.octetsNeeded((int)4, (long)relativeIndex);
        }

        @Override
        public int getRequiredInsertCount() {
            return this._entry.isStatic() ? 0 : this._entry.getIndex() + 1;
        }
    }

    private static class ReferencedNameEntry
    extends EncodableEntry {
        private final Entry _nameEntry;
        private final HttpField _field;
        private final boolean _huffman;

        public ReferencedNameEntry(Entry nameEntry, HttpField field, boolean huffman) {
            this._nameEntry = nameEntry;
            this._field = field;
            this._huffman = huffman;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            boolean allowIntermediary = false;
            boolean isStatic = this._nameEntry.isStatic();
            if (isStatic) {
                buffer.put((byte)(0x50 | (allowIntermediary ? 32 : 0)));
                int relativeIndex = this._nameEntry.getIndex();
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)4, (long)relativeIndex);
            } else if (this._nameEntry.getIndex() < base) {
                buffer.put((byte)(0x40 | (allowIntermediary ? 32 : 0)));
                int relativeIndex = base - (this._nameEntry.getIndex() + 1);
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)4, (long)relativeIndex);
            } else {
                buffer.put((byte)(allowIntermediary ? 8 : 0));
                int relativeIndex = this._nameEntry.getIndex() - base;
                NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)3, (long)relativeIndex);
            }
            NBitStringEncoder.encode((ByteBuffer)buffer, (int)8, (String)this.getValue(), (boolean)this._huffman);
        }

        @Override
        public int getRequiredSize(int base) {
            int nameOctets;
            if (this._nameEntry.isStatic()) {
                int relativeIndex = this._nameEntry.getIndex();
                nameOctets = NBitIntegerEncoder.octetsNeeded((int)4, (long)relativeIndex);
            } else if (this._nameEntry.getIndex() < base) {
                int relativeIndex = base - (this._nameEntry.getIndex() + 1);
                nameOctets = NBitIntegerEncoder.octetsNeeded((int)4, (long)relativeIndex);
            } else {
                int relativeIndex = this._nameEntry.getIndex() - base;
                nameOctets = NBitIntegerEncoder.octetsNeeded((int)3, (long)relativeIndex);
            }
            return nameOctets + NBitStringEncoder.octetsNeeded((int)8, (String)this.getValue(), (boolean)this._huffman);
        }

        @Override
        public int getRequiredInsertCount() {
            return this._nameEntry.isStatic() ? 0 : this._nameEntry.getIndex() + 1;
        }

        private String getValue() {
            String value = Objects.requireNonNull(this._field).getValue();
            return value == null ? "" : value;
        }
    }

    private static class LiteralEntry
    extends EncodableEntry {
        private final HttpField _field;
        private final boolean _huffman;

        public LiteralEntry(HttpField field, boolean huffman) {
            this._field = field;
            this._huffman = huffman;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            int allowIntermediary = 0;
            buffer.put((byte)(0x20 | allowIntermediary));
            NBitStringEncoder.encode((ByteBuffer)buffer, (int)4, (String)this.getName(), (boolean)this._huffman);
            NBitStringEncoder.encode((ByteBuffer)buffer, (int)8, (String)this.getValue(), (boolean)this._huffman);
        }

        @Override
        public int getRequiredSize(int base) {
            int encodedNameSize = NBitStringEncoder.octetsNeeded((int)4, (String)this.getName(), (boolean)this._huffman);
            int encodedValueSize = NBitStringEncoder.octetsNeeded((int)8, (String)this.getValue(), (boolean)this._huffman);
            return encodedNameSize + encodedValueSize;
        }

        @Override
        public int getRequiredInsertCount() {
            return 0;
        }

        private String getName() {
            String name = Objects.requireNonNull(this._field).getName();
            return name == null ? "" : name;
        }

        private String getValue() {
            String value = Objects.requireNonNull(this._field).getValue();
            return value == null ? "" : value;
        }
    }

    private static class PreEncodedEntry
    extends EncodableEntry {
        private final PreEncodedHttpField _httpField;

        public PreEncodedEntry(PreEncodedHttpField httpField) {
            this._httpField = httpField;
        }

        @Override
        public void encode(ByteBuffer buffer, int base) {
            this._httpField.putTo(buffer, HttpVersion.HTTP_3);
        }

        @Override
        public int getRequiredSize(int base) {
            return this._httpField.getEncodedLength(HttpVersion.HTTP_3);
        }

        @Override
        public int getRequiredInsertCount() {
            return 0;
        }
    }
}

