/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http3.ControlFlusher;
import org.eclipse.jetty.http3.Grease;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.InstructionFlusher;
import org.eclipse.jetty.http3.InstructionHandler;
import org.eclipse.jetty.http3.MessageFlusher;
import org.eclipse.jetty.http3.UnidirectionalStreamConnection;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.client.ClientProtocolSession;
import org.eclipse.jetty.quic.client.ClientQuicSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.common.StreamType;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHTTP3Session
extends ClientProtocolSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHTTP3Session.class);
    private final HTTP3Configuration configuration;
    private final HTTP3SessionClient session;
    private final QpackEncoder encoder;
    private final QpackDecoder decoder;
    private final ControlFlusher controlFlusher;
    private final MessageFlusher messageFlusher;

    public ClientHTTP3Session(HTTP3Configuration configuration, ClientQuicSession quicSession, Session.Client.Listener listener, Promise<Session.Client> promise) {
        super(quicSession);
        this.configuration = configuration;
        this.session = new HTTP3SessionClient(this, listener, promise);
        this.addBean((Object)this.session);
        this.session.setStreamIdleTimeout(configuration.getStreamIdleTimeout());
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializing HTTP/3 streams");
        }
        long encoderStreamId = this.newStreamId(StreamType.CLIENT_UNIDIRECTIONAL);
        QuicStreamEndPoint encoderEndPoint = this.openInstructionEndPoint(encoderStreamId);
        InstructionFlusher encoderInstructionFlusher = new InstructionFlusher((QuicSession)quicSession, encoderEndPoint, 2L);
        this.encoder = new QpackEncoder((Instruction.Handler)new InstructionHandler(encoderInstructionFlusher));
        this.encoder.setMaxHeadersSize(configuration.getMaxRequestHeadersSize());
        this.addBean(this.encoder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created encoder stream #{} on {}", (Object)encoderStreamId, (Object)encoderEndPoint);
        }
        long decoderStreamId = this.newStreamId(StreamType.CLIENT_UNIDIRECTIONAL);
        QuicStreamEndPoint decoderEndPoint = this.openInstructionEndPoint(decoderStreamId);
        InstructionFlusher decoderInstructionFlusher = new InstructionFlusher((QuicSession)quicSession, decoderEndPoint, 3L);
        this.decoder = new QpackDecoder((Instruction.Handler)new InstructionHandler(decoderInstructionFlusher));
        this.addBean(this.decoder);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created decoder stream #{} on {}", (Object)decoderStreamId, (Object)decoderEndPoint);
        }
        long controlStreamId = this.newStreamId(StreamType.CLIENT_UNIDIRECTIONAL);
        QuicStreamEndPoint controlEndPoint = this.openControlEndPoint(controlStreamId);
        this.controlFlusher = new ControlFlusher((QuicSession)quicSession, controlEndPoint, true);
        this.addBean(this.controlFlusher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("created control stream #{} on {}", (Object)controlStreamId, (Object)controlEndPoint);
        }
        this.messageFlusher = new MessageFlusher(quicSession.getByteBufferPool(), this.encoder, configuration.isUseOutputDirectByteBuffers());
        this.addBean(this.messageFlusher);
    }

    public QpackDecoder getQpackDecoder() {
        return this.decoder;
    }

    public QpackEncoder getQpackEncoder() {
        return this.encoder;
    }

    public HTTP3SessionClient getSessionClient() {
        return this.session;
    }

    public long newStreamId(StreamType streamType) {
        return this.getQuicSession().newStreamId(streamType);
    }

    protected void onStart() {
        HashMap<Long, Long> settings = this.session.onPreface();
        settings = settings != null ? new HashMap<Long, Long>(settings) : new HashMap();
        settings.compute(1L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxDecoderTableCapacity())) == 0L) {
                v = null;
            }
            return v;
        });
        settings.compute(6L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxResponseHeadersSize())) <= 0L) {
                v = null;
            }
            return v;
        });
        settings.compute(7L, (k, v) -> {
            if (v == null && (v = Long.valueOf(this.configuration.getMaxBlockedStreams())) == 0L) {
                v = null;
            }
            return v;
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("configuring local {} on {}", settings, (Object)this);
        }
        settings.forEach((key, value) -> {
            if (key == 1L) {
                this.decoder.setMaxTableCapacity(value.intValue());
            } else if (key == 6L) {
                this.decoder.setMaxHeadersSize(value.intValue());
            } else if (key == 7L) {
                this.decoder.setMaxBlockedStreams(value.intValue());
            }
        });
        SettingsFrame frame = new SettingsFrame(settings);
        if (this.controlFlusher.offer((Frame)frame, Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, this.session::onOpen, this::failControlStream))) {
            this.controlFlusher.iterate();
        }
    }

    public void onSettings(SettingsFrame frame) {
        Map settings = frame.getSettings();
        if (LOG.isDebugEnabled()) {
            LOG.debug("configuring encoder {} on {}", (Object)settings, (Object)this);
        }
        settings.forEach((key, value) -> {
            if (key == 1L) {
                int maxTableCapacity = (int)Math.min(value, Integer.MAX_VALUE);
                this.encoder.setMaxTableCapacity(maxTableCapacity);
                this.encoder.setTableCapacity(Math.min(maxTableCapacity, this.configuration.getMaxEncoderTableCapacity()));
            } else if (key == 6L) {
                int maxHeadersSize = (int)Math.min(value, (long)this.configuration.getMaxRequestHeadersSize());
                this.encoder.setMaxHeadersSize(maxHeadersSize);
            } else if (key == 7L) {
                int maxBlockedStreams = (int)Math.min(value, Integer.MAX_VALUE);
                this.encoder.setMaxBlockedStreams(maxBlockedStreams);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ignored {} setting {}={}", new Object[]{Grease.isGreaseValue((long)key) ? "grease" : "unknown", key, value});
            }
        });
    }

    private void failControlStream(Throwable failure) {
        long error = HTTP3ErrorCode.CLOSED_CRITICAL_STREAM_ERROR.code();
        this.onFailure(error, "control_stream_failure", failure);
    }

    protected void onStop() {
    }

    private QuicStreamEndPoint openInstructionEndPoint(long streamId) {
        return this.getOrCreateStreamEndPoint(streamId, QuicStreamEndPoint::opened);
    }

    private QuicStreamEndPoint openControlEndPoint(long streamId) {
        return this.getOrCreateStreamEndPoint(streamId, QuicStreamEndPoint::opened);
    }

    protected boolean onReadable(long readableStreamId) {
        StreamType streamType = StreamType.from((long)readableStreamId);
        if (streamType == StreamType.CLIENT_BIDIRECTIONAL) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("bidirectional stream #{} selected for read", (Object)readableStreamId);
            }
            return super.onReadable(readableStreamId);
        }
        QuicStreamEndPoint streamEndPoint = this.getOrCreateStreamEndPoint(readableStreamId, this::openUnidirectionalStreamEndPoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("unidirectional stream #{} selected for read: {}", (Object)readableStreamId, (Object)streamEndPoint);
        }
        return streamEndPoint.onReadable();
    }

    protected boolean onIdleTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout {} ms expired for {}", (Object)this.getQuicSession().getIdleTimeout(), (Object)this);
        }
        return this.session.onIdleTimeout();
    }

    protected void onFailure(long error, String reason, Throwable failure) {
        this.session.onSessionFailure(error, reason, failure);
    }

    public void inwardClose(long error, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("inward closing 0x{}/{} on {}", new Object[]{Long.toHexString(error), reason, this});
        }
        this.session.inwardClose(error, reason);
    }

    public CompletableFuture<Void> shutdown() {
        return this.session.shutdown();
    }

    protected void onClose(long error, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely 0x{}/{} {}", new Object[]{Long.toHexString(error), reason, this});
        }
        this.session.onClose(error, reason);
    }

    private void openUnidirectionalStreamEndPoint(QuicStreamEndPoint endPoint) {
        UnidirectionalStreamConnection connection = new UnidirectionalStreamConnection(endPoint, this.getQuicSession().getExecutor(), this.getQuicSession().getByteBufferPool(), this.encoder, this.decoder, (ParserListener)this.session);
        endPoint.setConnection((Connection)connection);
        endPoint.opened();
    }

    void writeControlFrame(Frame frame, Callback callback) {
        if (this.controlFlusher.offer(frame, callback)) {
            this.controlFlusher.iterate();
        }
    }

    void writeMessageFrame(long streamId, Frame frame, Callback callback) {
        QuicStreamEndPoint endPoint = this.getOrCreateStreamEndPoint(streamId, arg_0 -> ((ClientHTTP3Session)this).openProtocolEndPoint(arg_0));
        if (this.messageFlusher.offer(endPoint, frame, callback)) {
            this.messageFlusher.iterate();
        }
    }
}

