/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstructionFlusher
extends IteratingCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InstructionFlusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Instruction> queue = new ArrayDeque<Instruction>();
    private final ByteBufferPool bufferPool;
    private final ByteBufferPool.Accumulator accumulator;
    private final QuicStreamEndPoint endPoint;
    private final long streamType;
    private boolean initialized;
    private Throwable terminated;

    public InstructionFlusher(QuicSession session, QuicStreamEndPoint endPoint, long streamType) {
        this.bufferPool = session.getByteBufferPool();
        this.accumulator = new ByteBufferPool.Accumulator();
        this.endPoint = endPoint;
        this.streamType = streamType;
    }

    public boolean offer(List<Instruction> instructions) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.queue.addAll(instructions);
            }
        }
        return closed == null;
    }

    protected IteratingCallback.Action process() {
        ArrayList<Instruction> instructions;
        try (AutoLock ignored = this.lock.lock();){
            if (this.queue.isEmpty()) {
                IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                return action;
            }
            instructions = new ArrayList<Instruction>(this.queue);
            this.queue.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", instructions, (Object)this);
        }
        instructions.forEach(i -> i.encode(this.bufferPool, this.accumulator));
        if (!this.initialized) {
            this.initialized = true;
            RetainableByteBuffer buffer = this.bufferPool.acquire(VarLenInt.length(this.streamType), false);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            VarLenInt.encode(byteBuffer, this.streamType);
            byteBuffer.flip();
            this.accumulator.insert(0, buffer);
        }
        List buffers = this.accumulator.getByteBuffers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} buffers ({} bytes) on {}", new Object[]{buffers.size(), this.accumulator.getTotalLength(), this});
        }
        this.endPoint.write((Callback)this, (ByteBuffer[])buffers.toArray(ByteBuffer[]::new));
        return IteratingCallback.Action.SCHEDULED;
    }

    protected void onSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("succeeded to write {} buffers on {}", (Object)this.accumulator.getByteBuffers().size(), (Object)this);
        }
        this.accumulator.release();
    }

    protected void onCompleteFailure(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failed to write {} buffers on {}", new Object[]{this.accumulator.getByteBuffers().size(), this, failure});
        }
        this.accumulator.release();
        try (AutoLock ignored = this.lock.lock();){
            this.terminated = failure;
            this.queue.clear();
        }
        long error = HTTP3ErrorCode.INTERNAL_ERROR.code();
        this.endPoint.close(error, failure);
        this.endPoint.getQuicSession().getProtocolSession().outwardClose(error, "instruction_stream_failure");
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    public String toString() {
        return String.format("%s#%s", super.toString(), this.endPoint.getStreamId());
    }
}

