/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.session.infinispan.InfinispanSessionData;
import org.eclipse.jetty.session.infinispan.QueryManager;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.infinispan.commons.api.BasicCache;

@ManagedObject
public class InfinispanSessionDataStore
extends AbstractSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private BasicCache<String, SessionData> _cache;
    private int _infinispanIdleTimeoutSec;
    private QueryManager _queryManager;
    private boolean _passivating;

    public BasicCache<String, SessionData> getCache() {
        return this._cache;
    }

    public void setCache(BasicCache<String, SessionData> cache) {
        this._cache = cache;
    }

    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this._queryManager = queryManager;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._cache == null) {
            throw new IllegalStateException("No cache");
        }
        try {
            this._passivating = false;
            Class<?> remoteClass = Thread.currentThread().getContextClassLoader().loadClass("org.infinispan.client.hotrod.RemoteCache");
            if (remoteClass.isAssignableFrom(this._cache.getClass())) {
                this._passivating = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public SessionData doLoad(String id) throws Exception {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading session {} from infinispan", new Object[]{id});
            }
            InfinispanSessionData sd = (InfinispanSessionData)((Object)this._cache.get((Object)this.getCacheKey(id)));
            if (this.isPassivating() && sd != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deserializing session attributes for {}", new Object[]{id});
                }
                sd.deserializeAttributes();
            }
            return sd;
        }
        catch (Exception e) {
            throw new UnreadableSessionDataException(id, this._context, (Throwable)e);
        }
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting session with id {} from infinispan", new Object[]{id});
        }
        return this._cache.remove((Object)this.getCacheKey(id)) != null;
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        if (candidates != null) {
            for (String candidate : candidates) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Checking expiry for candidate {}", new Object[]{candidate});
                }
                try {
                    SessionData sd = this.load(candidate);
                    if (sd == null) {
                        expired.add(candidate);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Session {} does not exist in infinispan", new Object[]{candidate});
                        continue;
                    }
                    if (this._context.getWorkerName().equals(sd.getLastNode())) {
                        if (sd.getExpiry() <= 0L || sd.getExpiry() > now) continue;
                        expired.add(candidate);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Session {} managed by {} is expired", new Object[]{candidate, this._context.getWorkerName()});
                        continue;
                    }
                    if (this._lastExpiryCheckTime <= 0L) {
                        if (sd.getExpiry() <= 0L || sd.getExpiry() >= now - 1000L * (long)(3 * this._gracePeriodSec)) continue;
                        expired.add(candidate);
                        continue;
                    }
                    if (sd.getExpiry() <= 0L || sd.getExpiry() >= now - 1000L * (long)this._gracePeriodSec) continue;
                    expired.add(candidate);
                }
                catch (Exception e) {
                    LOG.warn("Error checking if candidate {} is expired", new Object[]{candidate, e});
                }
            }
        }
        if (this._queryManager != null) {
            long upperBound = now;
            upperBound = this._lastExpiryCheckTime <= 0L ? now - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}- Pass 2: Searching for sessions expired before {}", new Object[]{this._context.getWorkerName(), upperBound});
            }
            for (String sessionId : this._queryManager.queryExpiredSessions(upperBound)) {
                expired.add(sessionId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}- Found expired sessionId=", new Object[]{this._context.getWorkerName(), sessionId});
            }
        }
        return expired;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (data.getMaxInactiveMs() > 0L && this.getInfinispanIdleTimeoutSec() > 0) {
            this._cache.put((Object)this.getCacheKey(id), (Object)((InfinispanSessionData)data), -1L, TimeUnit.MILLISECONDS, (long)this.getInfinispanIdleTimeoutSec(), TimeUnit.SECONDS);
        } else {
            this._cache.put((Object)this.getCacheKey(id), (Object)((InfinispanSessionData)data));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {} saved to infinispan, expires {} ", new Object[]{id, data.getExpiry()});
        }
    }

    public String getCacheKey(String id) {
        return this._context.getCanonicalContextPath() + "_" + this._context.getVhost() + "_" + id;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return this._passivating;
    }

    public boolean exists(final String id) throws Exception {
        final AtomicBoolean reference = new AtomicBoolean();
        final AtomicReference exception = new AtomicReference();
        Runnable load = new Runnable(){

            @Override
            public void run() {
                try {
                    SessionData sd = InfinispanSessionDataStore.this.load(id);
                    if (sd == null) {
                        reference.set(false);
                        return;
                    }
                    if (sd.getExpiry() <= 0L) {
                        reference.set(true);
                    } else {
                        reference.set(sd.getExpiry() > System.currentTimeMillis());
                    }
                }
                catch (Exception e) {
                    exception.set(e);
                }
            }
        };
        this._context.run(load);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return reference.get();
    }

    public SessionData newSessionData(String id, long created, long accessed, long lastAccessed, long maxInactiveMs) {
        return new InfinispanSessionData(id, this._context.getCanonicalContextPath(), this._context.getVhost(), created, accessed, lastAccessed, maxInactiveMs);
    }

    public void setInfinispanIdleTimeoutSec(int sec) {
        this._infinispanIdleTimeoutSec = sec;
    }

    @ManagedAttribute(value="infinispan idle timeout sec", readonly=true)
    public int getInfinispanIdleTimeoutSec() {
        return this._infinispanIdleTimeoutSec;
    }

    public String toString() {
        return String.format("%s[cache=%s,idleTimeoutSec=%d]", super.toString(), this._cache == null ? "" : this._cache.getName(), this._infinispanIdleTimeoutSec);
    }
}

