/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnectionFactory;

public class ALPNClientConnectionFactory
extends NegotiatingClientConnectionFactory {
    private final Executor executor;
    private final List<String> protocols;

    public ALPNClientConnectionFactory(Executor executor, ClientConnectionFactory connectionFactory, List<String> protocols) {
        super(connectionFactory);
        this.executor = executor;
        this.protocols = protocols;
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("ALPN protocol list cannot be empty");
        }
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ALPNClientConnection connection = new ALPNClientConnection(endPoint, this.executor, this.getClientConnectionFactory(), (SSLEngine)context.get("ssl.engine"), context, this.protocols);
        return this.customize((Connection)connection, context);
    }
}

