/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.JarScanner;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFinder {
    private Map<String, ParsedClass> parsedClasses = new HashMap<String, ParsedClass>();

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.endsWith(".class")) {
            name = name.substring(0, name.length() - ".class".length());
        }
        name = name.replace('$', '.');
        return name.replace('/', '.');
    }

    public static Class convertType(Type t) throws Exception {
        if (t == null) {
            return null;
        }
        switch (t.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 9: {
                Class clazz = AnnotationFinder.convertType(t.getElementType());
                return Array.newInstance(clazz, 0).getClass();
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 10: {
                return Loader.loadClass(null, (String)t.getClassName());
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public static Class[] convertTypes(Type[] types) throws Exception {
        if (types == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            classArray[i] = AnnotationFinder.convertType(types[i]);
        }
        return classArray;
    }

    public void find(String className, ClassNameResolver resolver) throws Exception {
        if (className == null) {
            return;
        }
        if (!resolver.isExcluded(className) && (this.parsedClasses.get(className) == null || resolver.shouldOverride(className))) {
            this.parsedClasses.remove(className);
            className = className.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)className, (boolean)false);
            if (resource != null) {
                this.scanClass(resource.openStream());
            }
        }
    }

    public void find(String[] classNames, ClassNameResolver resolver) throws Exception {
        if (classNames == null) {
            return;
        }
        this.find(Arrays.asList(classNames), resolver);
    }

    public void find(List<String> classNames, ClassNameResolver resolver) throws Exception {
        for (String s : classNames) {
            if (resolver.isExcluded(s) || this.parsedClasses.get(s) != null && !resolver.shouldOverride(s)) continue;
            this.parsedClasses.remove(s);
            s = s.replace('.', '/') + ".class";
            URL resource = Loader.getResource(this.getClass(), (String)s, (boolean)false);
            if (resource == null) continue;
            this.scanClass(resource.openStream());
        }
    }

    public void find(Resource dir, ClassNameResolver resolver) throws Exception {
        if (!dir.isDirectory() || !dir.exists()) {
            return;
        }
        String[] files = dir.list();
        for (int f = 0; files != null && f < files.length; ++f) {
            try {
                String name;
                Resource res = dir.addPath(files[f]);
                if (res.isDirectory()) {
                    this.find(res, resolver);
                }
                if (!(name = res.getName()).endsWith(".class") || resolver.isExcluded(name) || this.parsedClasses.get(name) != null && !resolver.shouldOverride(name)) continue;
                this.parsedClasses.remove(name);
                this.scanClass(res.getURL().openStream());
                continue;
            }
            catch (Exception ex) {
                Log.warn((String)"EXCEPTION ", (Throwable)ex);
            }
        }
    }

    public void find(ClassLoader loader, boolean visitParents, boolean nullInclusive, final ClassNameResolver resolver) throws Exception {
        if (loader == null) {
            return;
        }
        if (!(loader instanceof URLClassLoader)) {
            return;
        }
        JarScanner scanner = new JarScanner(){

            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    String shortName;
                    String name = entry.getName();
                    if (name.toLowerCase().endsWith(".class") && !resolver.isExcluded(shortName = name.replace('/', '.').substring(0, name.length() - 6)) && (AnnotationFinder.this.parsedClasses.get(shortName) == null || resolver.shouldOverride(shortName))) {
                        AnnotationFinder.this.parsedClasses.remove(shortName);
                        Resource clazz = Resource.newResource((String)("jar:" + jarUri + "!/" + name));
                        AnnotationFinder.this.scanClass(clazz.getInputStream());
                    }
                }
                catch (Exception e) {
                    Log.warn((String)("Problem processing jar entry " + entry), (Throwable)e);
                }
            }
        };
        scanner.scan(null, loader, nullInclusive, visitParents);
    }

    public void find(URI[] uris, final ClassNameResolver resolver) throws Exception {
        if (uris == null) {
            return;
        }
        JarScanner scanner = new JarScanner(){

            public void processEntry(URI jarUri, JarEntry entry) {
                try {
                    String shortName;
                    String name = entry.getName();
                    if (name.toLowerCase().endsWith(".class") && !resolver.isExcluded(shortName = name.replace('/', '.').substring(0, name.length() - 6)) && (AnnotationFinder.this.parsedClasses.get(shortName) == null || resolver.shouldOverride(shortName))) {
                        AnnotationFinder.this.parsedClasses.remove(shortName);
                        Resource clazz = Resource.newResource((String)("jar:" + jarUri + "!/" + name));
                        AnnotationFinder.this.scanClass(clazz.getInputStream());
                    }
                }
                catch (Exception e) {
                    Log.warn((String)("Problem processing jar entry " + entry), (Throwable)e);
                }
            }
        };
        scanner.scan(null, uris, true);
    }

    protected boolean excludeClass(String name) {
        return false;
    }

    public List<Class<?>> getClassesForAnnotation(Class<?> annotationClass) throws Exception {
        ArrayList classes = new ArrayList();
        for (Map.Entry<String, ParsedClass> e : this.parsedClasses.entrySet()) {
            ParsedClass pc = e.getValue();
            Map<String, Map<String, Object>> annotations = pc.getAnnotations();
            for (String key : annotations.keySet()) {
                if (!key.equals(annotationClass.getName())) continue;
                classes.add(pc.toClass());
            }
        }
        return classes;
    }

    public List<Method> getMethodsForAnnotation(Class<?> annotationClass) throws Exception {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, ParsedClass> e : this.parsedClasses.entrySet()) {
            ParsedClass pc = e.getValue();
            List<ParsedMethod> pmethods = pc.getMethods();
            for (ParsedMethod p : pmethods) {
                for (String key : p.getAnnotations().keySet()) {
                    if (!key.equals(annotationClass.getName())) continue;
                    methods.add(p.toMethod());
                }
            }
        }
        return methods;
    }

    public List<Field> getFieldsForAnnotation(Class<?> annotation) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry<String, ParsedClass> e : this.parsedClasses.entrySet()) {
            ParsedClass pc = e.getValue();
            List<ParsedField> pfields = pc.getFields();
            for (ParsedField f : pfields) {
                for (String key : f.getAnnotations().keySet()) {
                    if (!key.equals(annotation.getName())) continue;
                    fields.add(f.toField());
                }
            }
        }
        return fields;
    }

    public String toString() {
        StringBuffer strbuff = new StringBuffer();
        for (Map.Entry<String, ParsedClass> e : this.parsedClasses.entrySet()) {
            strbuff.append((Object)e.getValue());
            strbuff.append("\n");
        }
        return strbuff.toString();
    }

    private void scanClass(InputStream is) throws IOException {
        ClassReader reader = new ClassReader(is);
        reader.accept((ClassVisitor)new MyClassVisitor(), 7);
    }

    public class MyClassVisitor
    extends EmptyVisitor {
        ParsedClass pclass;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.pclass = new ParsedClass(name, superName);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!AnnotationFinder.this.parsedClasses.containsKey(this.pclass.getClassName())) {
                AnnotationFinder.this.parsedClasses.put(this.pclass.getClassName(), this.pclass);
            }
            return this.pclass.addAnnotation(desc);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ParsedMethod method;
            if (!AnnotationFinder.this.parsedClasses.values().contains((Object)this.pclass)) {
                AnnotationFinder.this.parsedClasses.put(this.pclass.getClassName(), this.pclass);
            }
            if ((method = this.pclass.getMethod(name, desc)) == null) {
                method = new ParsedMethod(this.pclass, name, desc);
            }
            return method;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ParsedField field;
            if (!AnnotationFinder.this.parsedClasses.values().contains((Object)this.pclass)) {
                AnnotationFinder.this.parsedClasses.put(this.pclass.getClassName(), this.pclass);
            }
            if ((field = this.pclass.getField(name)) == null) {
                field = new ParsedField(this.pclass, name);
            }
            return field;
        }
    }

    public static class ParsedField
    extends AnnotatedStructure {
        ParsedClass pclass;
        String fieldName;
        Field field;

        public ParsedField(ParsedClass pclass, String name) {
            this.pclass = pclass;
            this.fieldName = name;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.pclass.addField(this);
            return this.addAnnotation(desc);
        }

        public Field toField() throws Exception {
            if (this.field == null) {
                this.field = this.pclass.toClass().getDeclaredField(this.fieldName);
            }
            return this.field;
        }

        public boolean matches(String name) {
            return this.fieldName.equals(name);
        }

        public String toString() {
            return this.pclass.getClassName() + "." + this.fieldName + "\n\t" + super.toString();
        }
    }

    public static class ParsedMethod
    extends AnnotatedStructure {
        ParsedClass pclass;
        String methodName;
        String paramString;
        Method method;

        public ParsedMethod(ParsedClass pclass, String name, String paramString) {
            this.pclass = pclass;
            this.methodName = name;
            this.paramString = paramString;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.pclass.addMethod(this);
            return this.addAnnotation(desc);
        }

        public Method toMethod() throws Exception {
            if (this.method == null) {
                Type[] types = null;
                if (this.paramString != null) {
                    types = Type.getArgumentTypes((String)this.paramString);
                }
                Class[] args = AnnotationFinder.convertTypes(types);
                this.method = this.pclass.toClass().getDeclaredMethod(this.methodName, args);
            }
            return this.method;
        }

        public boolean matches(String name, String paramString) {
            if (!this.methodName.equals(name)) {
                return false;
            }
            if (this.paramString != null && this.paramString.equals(paramString)) {
                return true;
            }
            return this.paramString == paramString;
        }

        public String toString() {
            return this.pclass.getClassName() + "." + this.methodName + "\n\t" + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParsedClass
    extends AnnotatedStructure {
        String className;
        String superClassName;
        Class clazz;
        List<ParsedMethod> methods = new ArrayList<ParsedMethod>();
        List<ParsedField> fields = new ArrayList<ParsedField>();

        public ParsedClass(String className, String superClassName) {
            this.className = AnnotationFinder.normalize(className);
            this.superClassName = AnnotationFinder.normalize(superClassName);
        }

        public String getClassName() {
            return this.className;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public Class toClass() throws ClassNotFoundException {
            if (this.clazz == null) {
                this.clazz = Loader.loadClass(null, (String)this.className);
            }
            return this.clazz;
        }

        public List<ParsedMethod> getMethods() {
            return this.methods;
        }

        public ParsedMethod getMethod(String name, String paramString) {
            Iterator<ParsedMethod> itor = this.methods.iterator();
            ParsedMethod method = null;
            while (itor.hasNext() && method == null) {
                ParsedMethod m = itor.next();
                if (!m.matches(name, paramString)) continue;
                method = m;
            }
            return method;
        }

        public void addMethod(ParsedMethod m) {
            if (this.getMethod(m.methodName, m.paramString) != null) {
                return;
            }
            this.methods.add(m);
        }

        public List<ParsedField> getFields() {
            return this.fields;
        }

        public ParsedField getField(String name) {
            Iterator<ParsedField> itor = this.fields.iterator();
            ParsedField field = null;
            while (itor.hasNext() && field == null) {
                ParsedField f = itor.next();
                if (!f.matches(name)) continue;
                field = f;
            }
            return field;
        }

        public void addField(ParsedField f) {
            if (this.getField(f.fieldName) != null) {
                return;
            }
            this.fields.add(f);
        }

        @Override
        public String toString() {
            StringBuffer strbuff = new StringBuffer();
            strbuff.append(this.className + "\n");
            strbuff.append("Class annotations\n" + super.toString());
            strbuff.append("\n");
            strbuff.append("Method annotations\n");
            for (ParsedMethod p : this.methods) {
                strbuff.append((Object)((Object)p) + "\n");
            }
            strbuff.append("\n");
            strbuff.append("Field annotations\n");
            for (ParsedField f : this.fields) {
                strbuff.append((Object)((Object)f) + "\n");
            }
            strbuff.append("\n");
            return strbuff.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedStructure
    extends EmptyVisitor {
        Map<String, Map<String, Object>> annotations = new HashMap<String, Map<String, Object>>();

        public AnnotationVisitor addAnnotation(String name) {
            final HashMap annotationValues = new HashMap();
            this.annotations.put(AnnotationFinder.normalize(name), annotationValues);
            return new AnnotationVisitor(){

                public void visit(String name, Object value) {
                    annotationValues.put(name, value);
                }

                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    return null;
                }

                public AnnotationVisitor visitArray(String arg0) {
                    return null;
                }

                public void visitEnd() {
                }

                public void visitEnum(String name, String desc, String value) {
                }
            };
        }

        public Map<String, Map<String, Object>> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            StringBuffer strbuff = new StringBuffer();
            for (Map.Entry<String, Map<String, Object>> e : this.annotations.entrySet()) {
                strbuff.append(e.getKey() + "\n");
                for (Map.Entry<String, Object> v : e.getValue().entrySet()) {
                    strbuff.append("\t" + v.getKey() + "=" + v.getValue() + ", ");
                }
            }
            return strbuff.toString();
        }
    }
}

