/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServletSecurityAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private WebAppContext _context;

    public ServletSecurityAnnotationHandler(WebAppContext wac) {
        super(false);
        this._context = wac;
    }

    @Override
    public void doHandle(Class clazz) {
        ArrayList<ConstraintMapping> constraintMappings;
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            Log.warn((String)"SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
        if (servletSecurity == null) {
            return;
        }
        List<ServletMapping> servletMappings = this.getServletMappings(clazz.getCanonicalName());
        if (this.constraintsExist(servletMappings, (List<ConstraintMapping>)(constraintMappings = ((ConstraintAware)this._context.getSecurityHandler()).getConstraintMappings()))) {
            Log.warn((String)("Constraints already defined for " + clazz.getName() + ", skipping ServletSecurity annotation"));
            return;
        }
        constraintMappings = new ArrayList<ConstraintMapping>();
        HttpConstraint defaults = servletSecurity.value();
        Constraint defaultConstraint = this.makeConstraint(clazz, defaults.rolesAllowed(), defaults.value(), defaults.transportGuarantee());
        constraintMappings.addAll(this.makeMethodMappings(clazz, defaultConstraint, servletMappings, servletSecurity.httpMethodConstraints()));
        ConstraintAware securityHandler = (ConstraintAware)this._context.getSecurityHandler();
        for (ConstraintMapping m : constraintMappings) {
            securityHandler.addConstraintMapping(m);
        }
    }

    protected Constraint makeConstraint(Class servlet, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic permitOrDeny, ServletSecurity.TransportGuarantee transport) {
        Constraint constraint = new Constraint();
        if (rolesAllowed == null || rolesAllowed.length == 0) {
            if (permitOrDeny.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                constraint.setName(servlet.getName() + "-Deny");
                constraint.setAuthenticate(true);
            } else {
                constraint.setAuthenticate(false);
                constraint.setName(servlet.getName() + "-Permit");
            }
        } else {
            constraint.setAuthenticate(true);
            constraint.setRoles(rolesAllowed);
            constraint.setName(servlet.getName() + "-RolesAllowed");
        }
        constraint.setDataConstraint(transport.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL) ? 2 : 0);
        return constraint;
    }

    protected ConstraintMapping makeConstraintMapping(Constraint constraint, String url, String method, String[] omissions) {
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec(url);
        if (method != null) {
            mapping.setMethod(method);
        }
        if (omissions != null) {
            mapping.setMethodOmissions(omissions);
        }
        return mapping;
    }

    protected List<ConstraintMapping> makeMethodMappings(Class servlet, Constraint defaultConstraint, List<ServletMapping> servletMappings, HttpMethodConstraint[] annotations) {
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        for (ServletMapping sm : servletMappings) {
            for (String url : sm.getPathSpecs()) {
                ConstraintMapping defaultMapping = this.makeConstraintMapping(defaultConstraint, url, null, null);
                if (annotations != null && annotations.length > 0) {
                    ArrayList<String> omissions = new ArrayList<String>();
                    for (int i = 0; i < annotations.length; ++i) {
                        Constraint methodConstraint = this.makeConstraint(servlet, annotations[i].rolesAllowed(), annotations[i].emptyRoleSemantic(), annotations[i].transportGuarantee());
                        ConstraintMapping methodConstraintMapping = this.makeConstraintMapping(methodConstraint, url, annotations[i].value(), null);
                        mappings.add(methodConstraintMapping);
                        omissions.add(annotations[i].value());
                    }
                    defaultMapping.setMethodOmissions(omissions.toArray(new String[0]));
                }
                mappings.add(defaultMapping);
            }
        }
        return mappings;
    }

    protected List<ServletMapping> getServletMappings(String className) {
        ServletMapping[] mappings;
        ArrayList<ServletMapping> results = new ArrayList<ServletMapping>();
        for (ServletMapping mapping : mappings = this._context.getServletHandler().getServletMappings()) {
            ServletHolder holder = this._context.getServletHandler().getServlet(mapping.getServletName());
            if (!holder.getClassName().equals(className)) continue;
            results.add(mapping);
        }
        return results;
    }

    protected boolean constraintsExist(List<ServletMapping> servletMappings, List<ConstraintMapping> constraintMappings) {
        boolean exists = false;
        for (ServletMapping mapping : servletMappings) {
            String[] pathSpecs = mapping.getPathSpecs();
            if (pathSpecs == null) continue;
            block1: for (int i = 0; constraintMappings != null && i < constraintMappings.size() && !exists; ++i) {
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (!pathSpecs[j].equals(constraintMappings.get(i).getPathSpec())) continue;
                    exists = true;
                    continue block1;
                }
            }
        }
        return exists;
    }
}

