/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.dynamic;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.MultiplexHttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.http.HttpClientConnectionFactory;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;

public class HttpClientTransportDynamic
extends AbstractConnectorHttpClientTransport {
    private final List<ClientConnectionFactory.Info> factoryInfos;
    private final List<String> protocols;

    public HttpClientTransportDynamic() {
        this(new ClientConnector(), HttpClientConnectionFactory.HTTP11);
    }

    public HttpClientTransportDynamic(ClientConnector connector, ClientConnectionFactory.Info ... factoryInfos) {
        super(connector);
        this.addBean(connector);
        if (factoryInfos.length == 0) {
            factoryInfos = new ClientConnectionFactory.Info[]{HttpClientConnectionFactory.HTTP11};
        }
        this.factoryInfos = Arrays.asList(factoryInfos);
        this.protocols = Arrays.stream(factoryInfos).flatMap(info -> info.getProtocols().stream()).distinct().map(p -> p.toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
        for (ClientConnectionFactory.Info factoryInfo : factoryInfos) {
            this.addBean(factoryInfo);
        }
        this.setConnectionPoolFactory(destination -> new MultiplexConnectionPool(destination, destination.getHttpClient().getMaxConnectionsPerDestination(), destination, 1));
    }

    @Override
    public HttpDestination.Key newDestinationKey(HttpRequest request, Origin origin) {
        boolean ssl = HttpScheme.HTTPS.is(request.getScheme());
        String http1 = "http/1.1";
        String http2 = ssl ? "h2" : "h2c";
        List<Object> protocols = List.of();
        if (request.isVersionExplicit()) {
            String desired;
            HttpVersion version = request.getVersion();
            String string = desired = version == HttpVersion.HTTP_2 ? http2 : http1;
            if (this.protocols.contains(desired)) {
                protocols = List.of(desired);
            }
        } else {
            protocols = this.protocols.stream().filter(p -> p.equals(http1) || p.equals(http2)).collect(Collectors.toList());
        }
        if (protocols.isEmpty()) {
            return new HttpDestination.Key(origin, null);
        }
        return new HttpDestination.Key(origin, new HttpDestination.Protocol(protocols, ssl && protocols.contains(http2)));
    }

    @Override
    public HttpDestination newHttpDestination(HttpDestination.Key key) {
        return new MultiplexHttpDestination(this.getHttpClient(), key);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        HttpDestination.Protocol protocol = destination.getKey().getProtocol();
        Object factoryInfo = protocol == null ? this.factoryInfos.get(0) : (destination.isSecure() && protocol.isNegotiate() ? new ALPNClientConnectionFactory.ALPN(this.getClientConnector().getExecutor(), this::newNegotiatedConnection, protocol.getProtocols()) : this.findClientConnectionFactoryInfo(protocol.getProtocols()).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for " + protocol)));
        return factoryInfo.getClientConnectionFactory().newConnection(endPoint, context);
    }

    protected Connection newNegotiatedConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        try {
            ALPNClientConnection alpnConnection = (ALPNClientConnection)endPoint.getConnection();
            String protocol = alpnConnection.getProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ALPN negotiated {} among {}", new Object[]{protocol, alpnConnection.getProtocols()});
            }
            if (protocol == null) {
                throw new IOException("Could not negotiate protocol among " + alpnConnection.getProtocols());
            }
            List<String> protocols = List.of(protocol);
            ClientConnectionFactory.Info factoryInfo = this.findClientConnectionFactoryInfo(protocols).orElseThrow(() -> new IOException("Cannot find " + ClientConnectionFactory.class.getSimpleName() + " for negotiated protocol " + protocol));
            return factoryInfo.getClientConnectionFactory().newConnection(endPoint, context);
        }
        catch (Throwable failure) {
            this.connectFailed(context, failure);
            throw failure;
        }
    }

    private Optional<ClientConnectionFactory.Info> findClientConnectionFactoryInfo(List<String> protocols) {
        return this.factoryInfos.stream().filter(info -> info.matches(protocols)).findFirst();
    }
}

