/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.DuplexHttpDestination;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    public static final HttpDestination.Protocol HTTP11 = new HttpDestination.Protocol(List.of("http/1.1"), false);
    private int headerCacheSize = 1024;
    private boolean headerCacheCaseSensitive;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        this(new ClientConnector());
        this.getClientConnector().setSelectors(selectors);
    }

    public HttpClientTransportOverHTTP(ClientConnector connector) {
        super(connector);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), destination));
    }

    @Override
    public HttpDestination.Key newDestinationKey(HttpRequest request, Origin origin) {
        return new HttpDestination.Key(origin, HTTP11);
    }

    @Override
    public HttpDestination newHttpDestination(HttpDestination.Key key) {
        return new DuplexHttpDestination(this.getHttpClient(), key);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, (Promise<org.eclipse.jetty.client.api.Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{connection});
        }
        return this.customize((Connection)connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    public void setHeaderCacheSize(int headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }

    @ManagedAttribute(value="Whether the header field cache is case sensitive")
    public boolean isHeaderCacheCaseSensitive() {
        return this.headerCacheCaseSensitive;
    }

    public void setHeaderCacheCaseSensitive(boolean headerCacheCaseSensitive) {
        this.headerCacheCaseSensitive = headerCacheCaseSensitive;
    }
}

